efast_run_Analysis <-
function(FILEPATH,MEASURES,PARAMETERS,NUMCURVES,NUMSAMPLES,OUTPUTMEASURES_TO_TTEST,TTEST_CONF_INT,GRAPH_FLAG,
		EFASTRESULTFILENAME,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
{
	if(is.null(TIMEPOINTS) || length(TIMEPOINTS)==1)
	{
		if(file.exists(FILEPATH))
		{
			NUMPARAMS<-length(PARAMETERS) # of input factors (parameters varied)
		
			NUMOUTMEASURES<-length(MEASURES)
	
			# maximum number of fourier coefficients
			# that may be retained in calculating the partial
			# variances without interferences between the
			# assigned frequencies
			MI<-4  
			wantedN<-NUMSAMPLES*NUMPARAMS*NUMCURVES # wanted no. of sample points
			OMi<-floor(((wantedN/NUMCURVES)-1)/(2*MI)/NUMPARAMS)
	
			# RUNS HAVE BEEN DONE OUTSIDE OF R USING THE PARAMETER SETS GENERATED BY EFAST
			# READ IN THE MEDIAN RESULT SETS
	
			print("Producing eFAST Analysis (efast_run_analysis)")

			# CONSTRUCT THE FILE NAME, TAKING ANY TIMEPOINT INTO ACCOUNT
			if(is.null(TIMEPOINTS))
			{
				CURVE1RESULTSFILENAME<-paste(FILEPATH,"/Curve1_Results_Summary.csv",sep="")
			}
			else
			{
				CURVE1RESULTSFILENAME<-paste(FILEPATH,"/Curve1_",TIMEPOINTS,"_Results_Summary.csv",sep="")
			}


			# READ IN THE FIRST CURVE
			if(file.exists(CURVE1RESULTSFILENAME))
			{
				RESULTS<-read.csv(CURVE1RESULTSFILENAME,sep=",")

				# NOW READ IN ANY FURTHER CURVES
				if(NUMCURVES>1)
				{
					for(CURVE in 2:NUMCURVES)
					{
						# CONSTRUCT THE FILE NAME
						if(is.null(TIMEPOINTS))
						{
							CURVERESULTSFILENAME<-paste(FILEPATH,"/Curve",CURVE,"_Results_Summary.csv",sep="")
						}
						else
						{
							CURVERESULTSFILENAME<-paste(FILEPATH,"/Curve",CURVE,"_",TIMEPOINTS,"_Results_Summary.csv",sep="")
						}

						if(file.exists(CURVERESULTSFILENAME))
						{
							CURVERESULTS<-read.csv(CURVERESULTSFILENAME,sep=",")
							# NOTE THIS ASSUMES THAT THE RESULTS HAVE BEEN GENERATED WITH THE FIRST COLUMN CONTAINING NO SAMPLE COUNT
							# ADD TO THE PREVIOUS CURVES
							RESULTS<-cbind(RESULTS,CURVERESULTS[1:length(CURVERESULTS)])
						}
						else
						{
							print(paste("No summary file for Curve ",CURVE,". Are you sure you have run the method to generate it?",sep=""))
						}	
					
					}
				}
	
				# CONVERT THE RESULTS FILE FOR EASE OF PROCESSING LATER
				RESULTS<-as.matrix(RESULTS)
				# PUT IN MULTI DIMENSIONAL ARRAY
				# EACH DIMENSION CONTAINS ONE CURVE
				RESULTSARRAY<-array(RESULTS,dim=c(NUMSAMPLES,(NUMPARAMS*NUMOUTMEASURES),NUMCURVES))
		
				# NOW GENERATE THE SENSITIVITY INDEXES
				# efast_sd IS WITHIN efast_sd.R
				print("Generating Sensitivity Indexes")
				resultList<-efast_sd(RESULTSARRAY,OMi,MI,NUMOUTMEASURES,NUMPARAMS,NUMCURVES)
		
				# GET THE COEFFICIENTS OF VARIANCE
				cvSi_coeffResults<-NULL
				cvSTi_coeffResults<-NULL
				errorsSi<-NULL
				errorsSTi<-NULL
	
				for(OUTPUTMEASURE in 1:NUMOUTMEASURES)
				{
					# efast_cvmethod is within CVmethod.R
					outputMeasureCVs <- efast_cvmethod(resultList$Si, resultList$rangeSi,resultList$STi,resultList$rangeSTi,OUTPUTMEASURE,NUMPARAMS,NUMCURVES,NUMOUTMEASURES)
					cvSi_coeffResults <- rbind(cvSi_coeffResults,outputMeasureCVs$CVSi)
					cvSTi_coeffResults <- rbind(cvSTi_coeffResults,outputMeasureCVs$CVSTi)
					errorsSi <- cbind(errorsSi,outputMeasureCVs$errorSi)
					errorsSTi <- cbind(errorsSTi,outputMeasureCVs$errorSTi)
				}
	
				# TRANSPOSE SO THAT THE OUTPUT ORDERING IS IN THE SAME FORMAT AS THE REST OF THE RESULTS (MEASURES ARE COLUMNS, PARAMETERS ARE ROWS)
				cvSi_coeffResults<-t(cvSi_coeffResults)
				cvSTi_coeffResults<-t(cvSTi_coeffResults)
		
				# NOW DO THE T-TEST TO GET THE P-VALUES AGAINST THE DUMMY PARAMETER
				# efast_ttest IS WITHIN efast_ttest.R
		
				print("Generating measures of statistical significance")
				t_tests <- efast_ttest(resultList$Si,resultList$rangeSi,resultList$STi,resultList$rangeSTi,OUTPUTMEASURES_TO_TTEST,NUMPARAMS,NUMCURVES,TTEST_CONF_INT)
		
				# NOW GET THE OUTPUT IN A FORMAT WHICH CAN BE OUTPUT TO AN EASILY READABLE CSV FILE
		
				formattedResults<-NULL
				for(MEASURE in seq(OUTPUTMEASURES_TO_TTEST))
				{
					# OUTPUT FORMAT
					# COLUMNS ORDERED BY MEASURE
					# 5 COLUMNS PER MEASURE - (i) Si (ii) Si P Val (iii) STi (iv) STi P Val (v) SCi
		
					measureResults<-cbind(resultList$Si[,,MEASURE],t_tests$p_Si[,,MEASURE],resultList$STi[,,MEASURE],t_tests$p_STi[,,MEASURE],(1-resultList$STi[,,MEASURE]),cvSi_coeffResults[,MEASURE],cvSTi_coeffResults[,MEASURE],errorsSi[,MEASURE],errorsSTi[,MEASURE])

					colnames(measureResults)<-c(paste(MEASURES[MEASURE],"_Si",sep=""),paste(MEASURES[MEASURE],"_Si_PVal",sep=""),paste(MEASURES[MEASURE],"_STi",sep=""),paste(MEASURES[MEASURE],"_STi_PVal",sep=""),paste(MEASURES[MEASURE],"_SCi",sep=""),paste(MEASURES[MEASURE],"_Si_CoEff_of_Var",sep=""),paste(MEASURES[MEASURE],"_STi_CoEff_of_Var",sep=""),paste(MEASURES[MEASURE],"_Si_ErrorBar",sep=""),paste(MEASURES[MEASURE],"_STi_ErrorBar",sep=""))

					formattedResults<-cbind(formattedResults,measureResults)
				}

				rownames(formattedResults)<-c(PARAMETERS)

				# OUTPUT THE SUMMARY RESULTS FILES
				# A - THE FILE WITH THE AMOUNT OF VARIANCE ACCOUNTED FOR BY EACH PARAMETER
				RESULTSFILE = paste(FILEPATH,"/",EFASTRESULTFILENAME,sep="")
				write.csv(formattedResults,RESULTSFILE,quote = FALSE)

				print(paste("eFAST Results file generated. Output to ",RESULTSFILE,sep=""))
		
				# GRAPH THE RESULTS IF REQUIRED
				if(GRAPH_FLAG)
				{
					print("Graphing Results")
					efast_graph_Results(FILEPATH,PARAMETERS,resultList$Si,resultList$STi,errorsSi,errorsSTi,MEASURES,TIMEPOINTS,TIMEPOINTSCALE)
				}
			}
			else
			{
				print("No summary file for Curve 1. Are you sure you have run the method to generate it?")
			}
		}
		else
		{
			print("The directory specified in FILEPATH does not exist. No eFAST Graphs Created")
		}	
	}
	else
	{
		# PROCESS EACH TIMEPOINT, BY AMENDING THE FILENAMES AND RECALLING THIS FUNCTION
		for(n in 1:length(TIMEPOINTS))
		{
			TIMEPOINTPROCESSING<-TIMEPOINTS[n]
			print(paste("PROCESSING TIMEPOINT: ",TIMEPOINTPROCESSING,sep=""))

			EFASTRESULTFILENAMEFORMAT<-substr(EFASTRESULTFILENAME,(nchar(EFASTRESULTFILENAME)+1)-3,nchar(EFASTRESULTFILENAME))
			EFASTRESULTFILENAME_FULL<-paste(substr(EFASTRESULTFILENAME,0,nchar(EFASTRESULTFILENAME)-4),"_",TIMEPOINTPROCESSING,".",EFASTRESULTFILENAMEFORMAT,sep="")

			# NOW CALL THIS FUNCTION AGAIN TO DO THE TIMEPOINTS - WE SET THE TIMEPOINTS AND TIMEPOINTSCALE TO NULL NOW SO WE DONT END UP BACK IN THIS ELSE
			efast_run_Analysis(FILEPATH,MEASURES,PARAMETERS,NUMCURVES,NUMSAMPLES,OUTPUTMEASURES_TO_TTEST,TTEST_CONF_INT,GRAPH_FLAG,
						EFASTRESULTFILENAME_FULL,TIMEPOINTS=TIMEPOINTPROCESSING,TIMEPOINTSCALE)

		}
	}

}

