aa_analyse_all_sample_sizes_overTime <-
function(FILEPATH,SAMPLESIZES,NUMSUBSETSPERSAMPLESIZE,RESULTFILEFORMAT,RESULTFILENAME,ALTFILENAME,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,
			MEASURES,MEDIANSFILEFORMAT,MEDIANSFILENAME,ATESTRESULTFILENAME,LARGEDIFFINDICATOR,TIMEPOINTS,TIMEPOINTSCALE)

{
	for(k in 1:length(SAMPLESIZES))
	{
		SAMPLEPROCESSING <- SAMPLESIZES[k]

		for(n in 1:length(TIMEPOINTS))
		{
			TIMEPOINTANALYSED<-TIMEPOINTS[n]

			print(paste("Samples: ",SAMPLEPROCESSING," Timepoint: ",TIMEPOINTANALYSED,sep=""))

			# CONSTRUCT THE FILENAME FOR THIS TIMEPOINT
			# EXTENSION ISNT ADDED HERE, THIS IS ADDED WHEN READ IN LATER
			SIMRESULTFILENAME<-paste(RESULTFILENAME,"_",TIMEPOINTANALYSED,sep="")
			
				
			# CONSTRUCT ALTFILENAME ALSO IF BEING USED (NOT NULL)
			# AGAIN, WITHOUT EXTENSION
			if(!is.null(ALTFILENAME))
			{
				ALTFILENAME<-paste(ALTFILENAME,"_",TIMEPOINTANALYSED,sep="")
			}
			
			# Now generate the medians for each of the dummy parameter sets
			for(l in 1:NUMSUBSETSPERSAMPLESIZE)
			{
				FILEDIR<-paste(FILEPATH,"/",SAMPLEPROCESSING,"/",l,"/",sep="")
				
				# CONSTRUCT MEDIANS FILE NAME (IN CORRECT FORMAT) - AGAIN EXTENSION ADDED WHEN WRITTEN (SO MATCHES USER REQUIREMENTS OF
				# XML OR CSV)
				MEDIANSFILENAMEFULL<-paste(MEDIANSFILENAME,"_",TIMEPOINTANALYSED,sep="")
							
				# Get the median distributions for each subset
				getMediansSubset(FILEDIR,SAMPLEPROCESSING,MEASURES,RESULTFILEFORMAT,SIMRESULTFILENAME,ALTFILENAME,OUTPUTFILECOLSTART,OUTPUTFILECOLEND,
						MEDIANSFILEFORMAT,MEDIANSFILENAMEFULL)
			}

			# Process the distributions for this sample size - producing the A-Test result for each subset
			# THIS IS IN FILE RUNATEST.R
			ATESTRESULTFILENAMEFULL<-paste(ATESTRESULTFILENAME,"_",TIMEPOINTANALYSED,sep="")
			aa_getATestResults(FILEPATH,SAMPLEPROCESSING,NUMSUBSETSPERSAMPLESIZE,MEASURES,MEDIANSFILEFORMAT,MEDIANSFILENAMEFULL,ATESTRESULTFILENAMEFULL)
	
			# Draw the graph for this sample size
			GRAPHOUTPUTNAME<-paste(SAMPLEPROCESSING,"Samples_",TIMEPOINTANALYSED,".pdf",sep="")
			aa_graphATestsForSampleSize(FILEPATH,SAMPLEPROCESSING,MEASURES,NUMSUBSETSPERSAMPLESIZE,LARGEDIFFINDICATOR,ATESTRESULTFILENAMEFULL,
				GRAPHOUTPUTNAME,TIMEPOINTANALYSED,TIMEPOINTSCALE)
		}
	}
}

