% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_view.R
\name{stream_view}
\alias{stream_view}
\title{View Stream}
\usage{
stream_view(stream, ...)
}
\arguments{
\item{stream}{The stream to visualize.}

\item{...}{Additional optional arguments.}
}
\description{
Opens a Shiny gadget to visualize the given stream.
}
\examples{
\dontrun{
library(sparklyr)
sc <- spark_connect(master = "local")

dir.create("iris-in")
write.csv(iris, "iris-in/iris.csv", row.names = FALSE)

stream_read_csv(sc, "iris-in/") \%>\%
  stream_write_csv("iris-out/") \%>\%
  stream_view() \%>\%
  stream_stop()
}
}
