% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precondition.R
\name{ensure}
\alias{ensure}
\alias{ensure_scalar_integer}
\alias{ensure_scalar_double}
\alias{ensure_scalar_boolean}
\alias{ensure_scalar_character}
\title{Enforce Specific Structure for R Objects}
\usage{
ensure_scalar_integer(object, allow.na = FALSE, allow.null = FALSE,
  default = NULL)

ensure_scalar_double(object, allow.na = FALSE, allow.null = FALSE,
  default = NULL)

ensure_scalar_boolean(object, allow.na = FALSE, allow.null = FALSE,
  default = NULL)

ensure_scalar_character(object, allow.na = FALSE, allow.null = FALSE,
  default = NULL)
}
\arguments{
\item{object}{An \R object.}

\item{allow.na}{Are \code{NA} values permitted for this object?}

\item{allow.null}{Are \code{NULL} values permitted for this object?}

\item{default}{If \code{object} is \code{NULL}, what value should
be used in its place? If \code{default} is specified, \code{allow.null}
is ignored (and assumed to be \code{TRUE}).}
}
\description{
These routines are useful when preparing to pass objects to
a Spark routine, as it is often necessary to ensure certain
parameters are scalar integers, or scalar doubles, and so on.
}
