% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacy_initialize.R
\name{spacy_initialize}
\alias{spacy_initialize}
\title{Initialize spaCy}
\usage{
spacy_initialize(model = "en", python_executable = NULL, ask = FALSE,
  source_bash_profile = NULL, virtualenv = NULL, condaenv = NULL,
  entity = TRUE)
}
\arguments{
\item{model}{Language package for loading spacy. Example: \code{en} (English) and
\code{de} (German). Default is \code{en}.}

\item{python_executable}{the full path to the python excutable, for which spaCy is installed}

\item{ask}{logical; if \code{FALSE}, use the first spaCy installation found; 
if \code{TRUE}, list available spaCy installations and prompt the user 
for which to use. If another (e.g. \code{python_executable}) is set, then 
this value will always be treated as \code{FALSE}.}

\item{source_bash_profile}{logical; if \code{TRUE}, source \code{~/.bash_profile} before trying
to find python executables with spaCy installed. Most likely necessary to set \code{TRUE}, 
if using anaconda python in Mac or Linux. Default is \code{NULL} 
which functions as \code{TRUE} for non-Windows system (e.g. Mac/Linux) and 
\code{FALSE} for Windows system.}

\item{virtualenv}{set a path to the python virtual environment with spaCy installed
Example: \code{virtualenv = "~/myenv"}}

\item{condaenv}{set a path to the anaconda virtual environment with spaCy installed
Example: \code{condalenv = "myenv"}}

\item{entity}{logical; if \code{FALSE} is selected, named entity recognition is turned off 
in spaCy. This will speed up the parsing as it will exclude \code{ner} from the pipeline. 
For details of spaCy pipeline, 
see \url{https://spacy.io/usage/processing-pipelines}. The option \code{FALSE} is available only 
for spaCy version 2.0.0 or higher.}
}
\description{
Initialize spaCy to call from R.
}
\author{
Akitaka Matsuo
}
