% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formants.R
\name{.addFormants}
\alias{.addFormants}
\title{Add formants per sound}
\usage{
.addFormants(
  audio,
  formants,
  spectralEnvelope = NULL,
  action = c("add", "remove")[1],
  dB = NULL,
  specificity = 1,
  zFun = NULL,
  vocalTract = NA,
  formantDep = 1,
  formantDepStoch = 1,
  formantWidth = 1,
  formantCeiling = 2,
  lipRad = 6,
  noseRad = 4,
  mouthOpenThres = 0,
  mouth = NA,
  temperature = 0.025,
  formDrift = 0.3,
  formDisp = 0.2,
  smoothing = list(),
  windowLength_points = 800,
  overlap = 75,
  dynamicRange = 120,
  normalize = c("max", "orig", "none")[1],
  play = FALSE,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{formants}{either a character string like "aaui" referring to default
presets for speaker "M1" or a list of formant times, frequencies,
amplitudes, and bandwidths (see ex. below). \code{formants = NA} defaults
to schwa. Time stamps for formants and mouthOpening can be specified in ms
or an any other arbitrary scale. See \code{\link{getSpectralEnvelope}} for
more details}

\item{spectralEnvelope}{(optional): as an alternative to specifying formant
frequencies, we can provide the exact filter - a vector of non-negative
numbers specifying the power in each frequency bin on a linear scale
(interpolated to length equal to windowLength_points/2). A matrix
specifying the filter for each STFT step is also accepted. The easiest way
to create this matrix is to call soundgen:::getSpectralEnvelope or to use
the spectrum of a recorded sound}

\item{action}{'add' = add formants to the sound, 'remove' = remove formants
(inverse filtering)}

\item{dB}{if NULL (default), the spectral envelope is applied on the original
scale; otherwise, it is set to range from 1 to 10 ^ (dB / 20)}

\item{specificity}{a way to sharpen or blur the spectral envelope (spectrum ^
specificity) : 1 = no change, >1 = sharper, <1 = blurred}

\item{zFun}{(optional) an arbitrary function to apply to the spectrogram
prior to iSTFT, where "z" is the spectrogram - a matrix of complex values
(see examples)}

\item{vocalTract}{the length of vocal tract, cm. Used for calculating formant
dispersion (for adding extra formants) and formant transitions as the mouth
opens and closes. If \code{NULL} or \code{NA}, the length is estimated
based on specified formant frequencies, if any (anchor format)}

\item{formantDep}{scale factor of formant amplitude (1 = no change relative
to amplitudes in \code{formants})}

\item{formantDepStoch}{the amplitude of additional stochastic formants added
above the highest specified formant, dB (only if temperature > 0)}

\item{formantWidth}{scale factor of formant bandwidth (1 = no change)}

\item{formantCeiling}{frequency to which stochastic formants are calculated,
in multiples of the Nyquist frequency; increase up to ~10 for long vocal
tracts to avoid losing energy in the upper part of the spectrum}

\item{lipRad}{the effect of lip radiation on source spectrum, dB/oct (the
default of +6 dB/oct produces a high-frequency boost when the mouth is
open)}

\item{noseRad}{the effect of radiation through the nose on source spectrum,
dB/oct (the alternative to \code{lipRad} when the mouth is closed)}

\item{mouthOpenThres}{open the lips (switch from nose radiation to lip
radiation) when the mouth is open \code{>mouthOpenThres}, 0 to 1}

\item{mouth}{mouth opening (0 to 1, 0.5 = neutral, i.e. no
modification) (anchor format)}

\item{temperature}{hyperparameter for regulating the amount of stochasticity
in sound generation}

\item{formDrift, formDisp}{scaling factors for the effect of temperature on
formant drift and dispersal, respectively}

\item{smoothing}{a list of parameters passed to
\code{\link{getSmoothContour}} to control the interpolation and smoothing
of contours: interpol (approx / spline / loess), loessSpan, discontThres,
jumpThres}

\item{windowLength_points}{length of FFT window, points}

\item{overlap}{FFT window overlap, \%. For allowed values, see
\code{\link[seewave]{istft}}}

\item{normalize}{"orig" = same as input (default), "max" = maximum possible
peak amplitude, "none" = no normalization}

\item{play}{if TRUE, plays the synthesized sound using the default player on
your system. If character, passed to \code{\link[tuneR]{play}} as the name
of player to use, eg "aplay", "play", "vlc", etc. In case of errors, try
setting another default player for \code{\link[tuneR]{play}}}

\item{...}{other plotting parameters passed to \code{\link{spectrogram}}}
}
\description{
Internal soundgen function called by \code{\link{addFormants}}
}
\keyword{internal}
