% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{.fade}
\alias{.fade}
\title{Fade per sound}
\usage{
.fade(
  audio,
  fadeIn = 1000,
  fadeOut = 1000,
  fadeIn_points = NULL,
  fadeOut_points = NULL,
  samplingRate = NULL,
  shape = c("lin", "exp", "log", "cos", "logistic", "gaussian")[1],
  steepness = 1,
  plot = FALSE,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{fadeIn}{length of segments for fading in and out, ms (0 = no
fade)}

\item{fadeOut}{length of segments for fading in and out, ms (0 = no
fade)}

\item{fadeIn_points}{length of segments for fading in and out,
points (if specified, override \code{fadeIn/fadeOut})}

\item{fadeOut_points}{length of segments for fading in and out,
points (if specified, override \code{fadeIn/fadeOut})}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{shape}{controls the type of fade function: 'lin' = linear, 'exp' =
exponential, 'log' = logarithmic, 'cos' = cosine, 'logistic' = logistic
S-curve}

\item{steepness}{scaling factor regulating the steepness of fading curves
(except for shapes 'lin' and 'cos'): 0 = linear, >1 = steeper than default}

\item{plot}{if TRUE, produces an oscillogram of the waveform after fading}

\item{width}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{height}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{units}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters}
}
\description{
Internal soundgen function
}
\keyword{internal}
