% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\title{Resample a vector}
\usage{
resample(
  x,
  samplingRate = NULL,
  samplingRate_new = NULL,
  mult = NULL,
  len = NULL,
  lowPass = TRUE,
  na.rm = FALSE,
  reportEvery = NULL,
  saveAudio = NULL,
  plot = FALSE,
  savePlots = NULL,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{samplingRate_new}{an alternative to \code{mult} provided that the old
\code{samplingRate is know} (NB: \code{mult} takes precedence)}

\item{mult}{multiplier of sampling rate: new sampling rate = old sampling
rate x mult, so 1 = no effect, >1 = upsample, <1 = downsample}

\item{len}{if specified, overrides mult and samplingRate_new and simply
returns a vector of length \code{len}}

\item{lowPass}{if TRUE, applies a low-pass filter before decimating or after
upsampling to avoid aliasing}

\item{na.rm}{if TRUE, NAs are interpolated, otherwise they are preserved in
the output}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{saveAudio}{full path to the folder in which to save audio files (one
per detected syllable)}

\item{plot}{should a spectrogram be plotted? TRUE / FALSE}

\item{savePlots}{full path to the folder in which to save the plots (NULL =
don't save, '' = same folder as audio)}

\item{width}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{height}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{units}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters}
}
\description{
Changes the sampling rate without introducing artefacts like aliasing.
Algorithm: to downsample, applies a low-pass filter, then decimates with
\code{approx}; to upsample, performs linear interpolation with \code{approx},
then applies a low-pass filter. NAs can be interpolated or preserved in the
output. The length of output is determined, in order of precedence, by
\code{len / mult / samplingRate_new}.
}
\examples{
## Example 1: a short vector with NAs
x = c(NA, 1, 2, 3, NA, NA, 6, 7, 8, NA)

# upsample
soundgen::resample(x, mult = 3.5, lowPass = FALSE, plot = TRUE)  # just approx
soundgen::resample(x, mult = 3.5, lowPass = TRUE, plot = TRUE) # low-pass + approx
soundgen::resample(x, mult = 3.5, lowPass = FALSE, na.rm = TRUE, plot = TRUE)

# downsample
soundgen::resample(x, mult = 0.5, lowPass = TRUE, plot = TRUE)
soundgen::resample(x, mult = 0.5, na.rm = TRUE, plot = TRUE)
soundgen::resample(x, len = 5, na.rm = TRUE, plot = TRUE) # same


## Example 2: a sound
silence = rep(0, 10)
samplingRate = 1000
fr = seq(100, 300, length.out = 400)
x = c(silence, sin(cumsum(fr) * 2 * pi / samplingRate), silence)
spectrogram(x, samplingRate)

# downsample
x1 = soundgen:::resample(x, mult = 1 / 2.5)
spectrogram(x1, samplingRate / 2.5)  # no aliasing
# cf:
x1bad = soundgen:::resample(x, mult = 1 / 2.5, lowPass = FALSE)
spectrogram(x1bad, samplingRate / 2.5)  # aliasing

# upsample
x2 = soundgen:::resample(x, mult = 3)
spectrogram(x2, samplingRate * 3)  # nothing above the old Nyquist
# cf:
x2bad = soundgen:::resample(x, mult = 3, lowPass = FALSE)
spectrogram(x2bad, samplingRate * 3)  # high-frequency artefacts

\dontrun{
# Example 3: resample all audio files in a folder to 8000 Hz
resample('~/Downloads/temp', saveAudio = '~/Downloads/temp/sr8000/',
         samplingRate_new = 8000, savePlots = '~/Downloads/temp/sr8000/')
}
}
