% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftPitch.R
\name{.shiftPitch}
\alias{.shiftPitch}
\title{Shift pitch per sound}
\usage{
.shiftPitch(
  audio,
  multPitch,
  multFormants,
  timeStretch,
  freqWindow = NULL,
  dynamicRange = 80,
  windowLength = 50,
  step = NULL,
  overlap = 75,
  wn = "gaussian",
  interpol = c("approx", "spline")[1],
  propagation = c("time", "adaptive")[1],
  preserveEnv = NULL,
  transplantEnv_pars = list(),
  normalize = TRUE,
  play = FALSE
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{multPitch}{1 = no change, >1 = raise pitch (eg 1.1 = 10\% up, 2 = one
octave up), <1 = lower pitch. Anchor format accepted for multPitch /
multFormant / timeStretch (see \code{\link{soundgen}})}

\item{multFormants}{1 = no change, >1 = raise formants (eg 1.1 = 10\% up, 2 =
one octave up), <1 = lower formants}

\item{timeStretch}{1 = no change, >1 = longer, <1 = shorter}

\item{freqWindow}{the width of spectral smoothing window, Hz. Defaults to
detected f0 prior to pitch shifting - see \code{\link{shiftFormants}} for
discussion and examples}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, rectangular, blackman, flattop}

\item{interpol}{the method for interpolating scaled spectra and anchors}

\item{propagation}{the method for propagating phase: "time" = horizontal
propagation (default), "adaptive" = an experimental implementation of
"vocoder done right" (Prusa & Holighaus 2017)}

\item{preserveEnv}{if TRUE, transplants the amplitude envelope from the
original to the modified sound with \code{\link{transplantEnv}}. Defaults
to TRUE if no time stretching is performed and FALSE otherwise}

\item{transplantEnv_pars}{a list of parameters passed on to
\code{\link{transplantEnv}} if \code{preserveEnv = TRUE}}

\item{normalize}{if TRUE, scales input prior to FFT}

\item{play}{if TRUE, plays the synthesized sound using the default player on
your system. If character, passed to \code{\link[tuneR]{play}} as the name
of player to use, eg "aplay", "play", "vlc", etc. In case of errors, try
setting another default player for \code{\link[tuneR]{play}}}
}
\description{
Internal soundgen function called by \code{\link{shiftPitch}}
}
\keyword{internal}
