% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{HzToSemitones}
\alias{HzToSemitones}
\title{Convert Hz to semitones}
\usage{
HzToSemitones(h, ref = 0.5109875)
}
\arguments{
\item{h}{vector or matrix of frequencies (Hz)}

\item{ref}{frequency of the reference value (defaults to C-5, 0.51 Hz)}
}
\description{
Converts from Hz to semitones above C-5 (~0.5109875 Hz) or another reference
frequency. This may not seem very useful, but note that this gives us a nice
logarithmic scale for generating natural pitch transitions with the added
benefit of getting musical notation for free from \code{notesDict} (see
examples).
}
\examples{
s = HzToSemitones(c(440, 293, 115))
# to convert to musical notation
notesDict$note[1 + round(s)]
# note the "1 +": semitones ABOVE C-5, i.e. notesDict[1, ] is C-5

# Any reference tone can be specified. For ex., for semitones above C0, use:
HzToSemitones(440, ref = 16.35)
# TIP: see notesDict for a table of Hz frequencies to musical notation
}
\seealso{
\code{\link{semitonesToHz}}
}
