% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amplitude.R
\name{.getRMS}
\alias{.getRMS}
\title{RMS amplitude per sound}
\usage{
.getRMS(
  audio,
  windowLength = 50,
  step = NULL,
  overlap = 75,
  killDC = FALSE,
  normalize = TRUE,
  windowDC = 200,
  plot = TRUE,
  main = NULL,
  xlab = "",
  ylab = "",
  type = "b",
  col = "green",
  lwd = 2,
  width = 900,
  height = 500,
  units = "px",
  res = NA,
  ...
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{killDC}{if TRUE, removed DC offset (see also \code{\link{flatEnv}})}

\item{normalize}{if TRUE, the RMS amplitude is returned as proportion of
the maximum possible amplitude as given by \code{scale}}

\item{windowDC}{the window for calculating DC offset, ms}

\item{plot}{if TRUE, plot a contour of RMS amplitude}

\item{main}{graphical parameters for plotting}

\item{xlab}{general graphical parameters}

\item{ylab}{general graphical parameters}

\item{type}{graphical parameters pertaining to the RMS envelope}

\item{col}{graphical parameters pertaining to the RMS envelope}

\item{lwd}{graphical parameters pertaining to the RMS envelope}

\item{width}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{height}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{units}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{res}{graphical parameters for saving plots passed to
\code{\link[grDevices]{png}}}

\item{...}{other graphical parameters}
}
\description{
Internal soundgen function called by \code{\link{getRMS}}.
}
\keyword{internal}
