% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_analyze.R
\name{getPitchSpec}
\alias{getPitchSpec}
\title{BaNa pitch tracker}
\usage{
getPitchSpec(frame, specSmooth, specHNRslope, bin, HNR = NULL, specThres,
  specPeak, specSinglePeakCert, pitchFloor, pitchCeiling, specMerge, nCands)
}
\arguments{
\item{frame}{the real part of the spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{specSmooth}{the width of window for detecting peaks in the spectrum, Hz}

\item{specHNRslope}{when looking for putative harmonics in
the spectrum, the threshold for peak detection is calculated as
\code{specPeak * (1 - HNR * specHNRslope)}}

\item{bin}{the width of spectral bin in \code{frame}, Hz}

\item{HNR}{harmonics-to-noise ratio returned by \code{\link{getPitchAutocor}}}

\item{specThres}{(0 to 1) separate
voicing thresholds for detecting pitch candidates with three different
methods: autocorrelation, cepstrum, and BaNa algorithm (see Details). Note
that HNR is calculated even for unvoiced frames.}

\item{specPeak}{when looking for putative harmonics in
the spectrum, the threshold for peak detection is calculated as
\code{specPeak * (1 - HNR * specHNRslope)}}

\item{specSinglePeakCert}{(0 to 1) if F0 is calculated based on a single
harmonic ratio (as opposed to several ratios converging on the same
candidate), its certainty is taken to be \code{specSinglePeakCert}}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{specMerge}{pitch candidates within \code{specMerge} semitones are
merged with boosted certainty}

\item{nCands}{maximum number of pitch candidates per method (except for
\code{dom}, which returns at most one candidate per frame), normally 1...4}
}
\value{
Returns either NULL or a dataframe of pitch candidates.
}
\description{
Internal soundgen function.
}
\details{
Attempts to find F0 of a frame by calculating ratios of putative harmonics
(frequency domain analysis, ~ modified BaNa algorithm). See Ba et al. (2012)
"BaNa: A hybrid approach for noise resilient pitch detection." Statistical
Signal Processing Workshop (SSP), 2012 IEEE.
}
\keyword{internal}
