% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{highlight}
\alias{highlight}
\title{Highlight differences between strings.}
\usage{
highlight(source, target, affixes)
}
\arguments{
\item{source}{[character] A vector of strings to be highlighted.}

\item{target}{[character] A string to which \code{source} strings are to be compared.}

\item{affixes}{[character] A vector of two strings: the first to be prepended to highlighted bits, and the second to be appended to them.}
}
\value{
[character] The highlighted strings.
}
\description{
Add a prefix and a suffix to all the substrings that are different between a vector of source strings, and a target string.
}
\details{
The effect is similar to Unix \code{diff}, only all the differences are highlighted in the same colour, and a \code{"_"} is inerted where characters are missing. To save on speed, the function does not check the arguments are correct, etc.
}
\examples{
cat (soundcorrs:::highlight (c("kitten","mitten"), "sitting", c("\u001b[31m","\u001b[0m")))
}
\keyword{internal}
