% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{findExamples}
\alias{findExamples}
\title{Find all pairs/triples/... with corresponding sequences of sounds.}
\usage{
findExamples(data, ..., distance.start, distance.end, na.value, zeros, cols)
}
\arguments{
\item{data}{[soundcorrs] The dataset in which to look.}

\item{...}{[character] Sequences for which to look. May be regular expressions as defined in R, or in the \code{\link{transcription}}. If an empty string, anything will be considered a match.}

\item{distance.start}{[integer] The allowed distance between segments where the sound sequences begin. A negative value means alignment of the beginning of sequences will not be checked. Defaults to -1.}

\item{distance.end}{[integer] The allowed distance between segments where the sound sequences end. A negative value means alignment of the end of sequences will not be checked. Defaults to -1.}

\item{na.value}{[numeric] Treat \code{NA}’s as matches (\code{0}) or non-matches (\code{-1})? Defaults to \code{0}.}

\item{zeros}{[logical] Take linguistic zeros into account? Defaults to \code{FALSE}.}

\item{cols}{[character vector] Which columns of the dataset to return as the result. Can be a vector of names, \code{"aligned"} (the two columns with segmented, aligned words), or \code{"all"} (all columns). Defaults to \code{"aligned"}.}
}
\value{
[df.findExamples] A list with two fields: \code{$data}, a data frame with found examples; and \code{$which}, a logical vector showing which rows of \code{data} are considered matches.
}
\description{
Sift the dataset for word pairs/triples/... such that the first word in the first languages contains the first sequence, the one in the second language the second sequence, and so on.
}
\examples{
# In the examples below, non-ASCII characters had to be escaped for technical reasons.
# In the actual usage, Unicode is supported under BSD, Linux, and macOS.
dataset <- sampleSoundCorrsData.capitals
# Find examples which have "a" in all three languages.
findExamples (dataset, "a", "a", "a")
# Find examples where German has schwa, and Polish and Spanish have a Vr sequence.
findExamples (dataset, "\u0259", "Vr", "Vr")
# Find examples where German has a-umlaut, Polish has a or e, and Spanish has any sound at all.
findExamples (dataset, "\u00E4", "[ae]", "")
# Find examples where German has a linguistic zero while Polish and Spanish do not.
findExamples (dataset, "-", "[^-]", "[^-]", zeros=TRUE)
# Find examples where German has schwa, and Polish and Spanish have a.
findExamples (dataset, "\u0259", "a", "a", distance.start=-1, distance.end=-1)
# As above, but the schwa and the two a's must be in the same segment.
findExamples (dataset, "\u0259", "a", "a", distance.start=0, distance.end=0)
}
\seealso{
\code{\link{findPairs}}.
}
