% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_rank.R
\name{question_rank}
\alias{question_rank}
\title{Ranking question for learnr tutorials.}
\usage{
question_rank(text, ..., correct = "Correct!", incorrect = "Incorrect",
  loading = c("**Loading:** ", text, "<br/><br/><br/>"),
  submit_button = "Submit Answer", try_again_button = "Try Again",
  allow_retry = FALSE, random_answer_order = TRUE,
  options = sortable_options())
}
\arguments{
\item{text}{Question or option text}

\item{...}{parameters passed onto \code{\link[learnr:question]{learnr::question()}}.}

\item{correct}{For \code{question}, text to print for a correct answer (defaults
to "Correct!"). For \code{answer}, a boolean indicating whether this answer is
correct.}

\item{incorrect}{Text to print for an incorrect answer (defaults to "Incorrect")
when \code{allow_retry} is \code{FALSE}.}

\item{loading}{Loading text to display as a placeholder while the question is loaded}

\item{submit_button}{Label for the submit button. Defaults to \code{"Submit Answer"}}

\item{try_again_button}{Label for the try again button. Defaults to \code{"Submit Answer"}}

\item{allow_retry}{Allow retry for incorrect answers. Defaults to \code{FALSE}.}

\item{random_answer_order}{Display answers in a random order.}

\item{options}{Options to be supplied to \link{sortable_js} object. See \link{sortable_options} for more details}
}
\value{
A custom \code{learnr} question, with type \code{sortable_rank}.  See \code{\link[learnr:question_methods]{learnr::question_methods()}}
}
\description{
Add interactive ranking tasks to your \code{learnr} tutorials.  The student can
drag-and-drop the answer options into the desired order.
}
\details{
Each set of answer options must contain the same set of answer options. When
the question is completed, the first correct answer will be displayed.

Note that, by default, the answer order is randomized.
}
\examples{
## Example of rank problem inside a learnr tutorial
if (interactive()) {
  learnr::run_tutorial("question_rank", package = "sortable")
}
}
