\name{DT_cornhybrids}
\alias{DT_cornhybrids}
\alias{DTi_cornhybrids}
\alias{GT_cornhybrids}
\docType{data}
\title{
Corn crosses and markers
}
\description{
This dataset contains phenotpic data for plant height and grain yield for 100 out of 400 possible hybrids originated from 40 inbred lines belonging to 2 heterotic groups, 20 lines in each, 1600 rows exist for the 400 possible hybrids evaluated in 4 locations but only 100 crosses have phenotypic information.  The purpose of this data is to show how to predict the other 300 crosses.

The data contains 3 elements. The first is the phenotypic data and the parent information for each cross evaluated in the 4 locations. 1200 rows should have missing data but the 100 crosses performed were chosen to be able to estimate the GCA and SCA effects of everything.

The second element of the data set is the phenotypic data and other relevant information for the 40.

The third element is the genomic relationship matrix for the 40 inbred lines originated from 511 SNP markers and calculated using the A.mat function.

}
\usage{data("DT_cornhybrids")}
\format{
  The format is:
 chr "DT_cornhybrids"
}
\source{
This data was generated by a corn study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples using
#### command + shift + C |OR| control + shift + C
####=========================================####
# 
# data(DT_cornhybrids)
# DT <- DT_cornhybrids
# DTi <- DTi_cornhybrids
# GT <- GT_cornhybrids
# hybrid2 <- DT # extract cross data
# A <- GT
# K1 <- A[levels(hybrid2$GCA1), levels(hybrid2$GCA1)]; dim(K1)
# K2 <- A[levels(hybrid2$GCA2), levels(hybrid2$GCA2)]; dim(K2)
# S <- kronecker(K1, K2) ; dim(S)
# rownames(S) <- colnames(S) <- levels(hybrid2$SCA)
# 
# ans <- mmer(Yield ~ Location, 
#              random = ~ vs(GCA1,Gu=K1) + vs(GCA2,Gu=K2) + vs(SCA,Gu=S),
#              rcov=~units,
#              data=hybrid2)
# 
# 
# ####==========================================####
# ####==========================================####
# #### Example of multivariate model
# ####==========================================####
# ####==========================================####
# 
# data(DT_cornhybrids)
# hybrid2 <- DT_cornhybrids # extract cross data
# DTi <- DTi_cornhybrids
# GT <- GT_cornhybrids
# hybrid2 <- hybrid2[which(!is.na(hybrid2$Yield)),]
# names(hybrid2)[5:6] <- c("TY","PH")
# head(hybrid2)
# 
# A <- GT
# K1 <- A[levels(hybrid2$GCA1), levels(hybrid2$GCA1)]; dim(K1)
# K2 <- A[levels(hybrid2$GCA2), levels(hybrid2$GCA2)]; dim(K2)
# S <- kronecker(K1, K2) ; dim(S)
# rownames(S) <- colnames(S) <- levels(hybrid2$SCA)
# 
# ans <- mmer(cbind(TY,PH) ~ Location,
#              random = ~ vs(GCA2,Gu=K2) + vs(SCA,Gu=S),
#              rcov = ~ vs(units,Gtc=diag(2)),
#              data=hybrid2)

}
\keyword{datasets}
\seealso{The core functions of the package \code{\link{mmer}} }
