% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SolrClient.R
\docType{data}
\name{SolrClient}
\alias{SolrClient}
\title{Solr connection client}
\arguments{
\item{host}{(character) Host url. Deafault: 127.0.0.1}

\item{path}{(character) url path.}

\item{port}{(character/numeric) Port. Default: 8389}

\item{scheme}{(character) http scheme, one of http or https. Default: http}

\item{proxy}{List of arguments for a proxy connection, including one or
more of: url, port, username, password, and auth. See
\link[crul:proxy]{crul::proxy} for  help, which is used to construct the
proxy connection.}

\item{errors}{(character) One of \code{"simple"} or \code{"complete"}. Simple gives
http code and  error message on an error, while complete gives both http
code and error message, and stack trace, if available.}
}
\value{
Various output, see help files for each grouping of methods.
}
\description{
Solr connection client
}
\details{
\code{SolrClient} creates a R6 class object. The object is
not cloneable and is portable, so it can be inherited across packages
without complication.

\code{SolrClient} is used to initialize a client that knows about your
Solr instance, with options for setting host, port, http scheme,
and simple vs. complete error reporting
}
\section{SolrClient methods}{


Each of these methods also has a matching standalone exported
function that you can use by passing in the connection object made
by calling \code{SolrClient$new()}. Also, see the docs for each method for
parameter definitions and their default values.
\itemize{
\item \code{ping(name, wt = 'json', raw = FALSE, ...)}
\item \code{schema(name, what = '', raw = FALSE, ...)}
\item \code{commit(name, expunge_deletes = FALSE, wait_searcher = TRUE, soft_commit = FALSE, wt = 'json', raw = FALSE, ...)}
\item \code{optimize(name, max_segments = 1, wait_searcher = TRUE, soft_commit = FALSE, wt = 'json', raw = FALSE, ...)}
\item \code{config_get(name, what = NULL, wt = "json", raw = FALSE, ...)}
\item \code{config_params(name, param = NULL, set = NULL, unset = NULL, update = NULL, ...)}
\item \code{config_overlay(name, omitHeader = FALSE, ...)}
\item \code{config_set(name, set = NULL, unset = NULL, ...)}
\item \code{collection_exists(name, ...)}
\item \code{collection_list(raw = FALSE, ...)}
\item \code{collection_create(name, numShards = 1, maxShardsPerNode = 1, createNodeSet = NULL, collection.configName = NULL, replicationFactor = 1, router.name = NULL, shards = NULL, createNodeSet.shuffle = TRUE, router.field = NULL, autoAddReplicas = FALSE, async = NULL, raw = FALSE, callopts=list(), ...)}
\item \code{collection_addreplica(name, shard = NULL, route = NULL, node = NULL, instanceDir = NULL, dataDir = NULL, async = NULL, raw = FALSE, callopts=list(), ...)}
\item \code{collection_addreplicaprop(name, shard, replica, property, property.value, shardUnique = FALSE, raw = FALSE, callopts=list())}
\item \code{collection_addrole(role = "overseer", node, raw = FALSE, ...)}
\item \code{collection_balanceshardunique(name, property, onlyactivenodes = TRUE, shardUnique = NULL, raw = FALSE, ...)}
\item \code{collection_clusterprop(name, val, raw = FALSE, callopts=list())}
\item \code{collection_clusterstatus(name = NULL, shard = NULL, raw = FALSE, ...)}
\item \code{collection_createalias(alias, collections, raw = FALSE, ...)}
\item \code{collection_createshard(name, shard, createNodeSet = NULL, raw = FALSE, ...)}
\item \code{collection_delete(name, raw = FALSE, ...)}
\item \code{collection_deletealias(alias, raw = FALSE, ...)}
\item \code{collection_deletereplica(name, shard = NULL, replica = NULL, onlyIfDown = FALSE, raw = FALSE, callopts=list(), ...)}
\item \code{collection_deletereplicaprop(name, shard, replica, property, raw = FALSE, callopts=list())}
\item \code{collection_deleteshard(name, shard, raw = FALSE, ...)}
\item \code{collection_migrate(name, target.collection, split.key, forward.timeout = NULL, async = NULL, raw = FALSE, ...)}
\item \code{collection_overseerstatus(raw = FALSE, ...)}
\item \code{collection_rebalanceleaders(name, maxAtOnce = NULL, maxWaitSeconds = NULL, raw = FALSE, ...)}
\item \code{collection_reload(name, raw = FALSE, ...)}
\item \code{collection_removerole(role = "overseer", node, raw = FALSE, ...)}
\item \code{collection_requeststatus(requestid, raw = FALSE, ...)}
\item \code{collection_splitshard(name, shard, ranges = NULL, split.key = NULL, async = NULL, raw = FALSE, ...)}
\item \code{core_status(name = NULL, indexInfo = TRUE, raw = FALSE, callopts=list())}
\item \code{core_exists(name, callopts = list())}
\item \code{core_create(name, instanceDir = NULL, config = NULL, schema = NULL, dataDir = NULL, configSet = NULL, collection = NULL, shard = NULL, async=NULL, raw = FALSE, callopts=list(), ...)}
\item \code{core_unload(name, deleteIndex = FALSE, deleteDataDir = FALSE, deleteInstanceDir = FALSE, async = NULL, raw = FALSE, callopts = list())}
\item \code{core_rename(name, other, async = NULL, raw = FALSE, callopts=list())}
\item \code{core_reload(name, raw = FALSE, callopts=list())}
\item \code{core_swap(name, other, async = NULL, raw = FALSE, callopts=list())}
\item \code{core_mergeindexes(name, indexDir = NULL, srcCore = NULL, async = NULL, raw = FALSE, callopts = list())}
\item \code{core_requeststatus(requestid, raw = FALSE, callopts = list())}
\item \code{core_split(name, path = NULL, targetCore = NULL, ranges = NULL, split.key = NULL, async = NULL, raw = FALSE, callopts=list())}
\item \code{search(name = NULL, params = NULL, body = NULL, callopts = list(), raw = FALSE, parsetype = 'df', concat = ',', optimizeMaxRows = TRUE, minOptimizedRows = 50000L, ...)}
\item \code{facet(name = NULL, params = NULL, body = NULL, callopts = list(), raw = FALSE, parsetype = 'df', concat = ',', ...)}
\item \code{stats(name = NULL, params = list(q = '*:*', stats.field = NULL, stats.facet = NULL), body = NULL, callopts=list(), raw = FALSE, parsetype = 'df', ...)}
\item \code{highlight(name = NULL, params = NULL, body = NULL, callopts=list(), raw = FALSE, parsetype = 'df', ...)}
\item \code{group(name = NULL, params = NULL, body = NULL, callopts=list(), raw=FALSE, parsetype='df', concat=',', ...)}
\item \code{mlt(name = NULL, params = NULL, body = NULL, callopts=list(), raw=FALSE, parsetype='df', concat=',', optimizeMaxRows = TRUE, minOptimizedRows = 50000L, ...)}
\item \code{all(name = NULL, params = NULL, body = NULL, callopts=list(), raw=FALSE, parsetype='df', concat=',', optimizeMaxRows = TRUE, minOptimizedRows = 50000L, ...)}
\item \code{get(ids, name, fl = NULL, wt = 'json', raw = FALSE, ...)}
\item \code{add(x, name, commit = TRUE, commit_within = NULL, overwrite = TRUE, boost = NULL, wt = 'json', raw = FALSE, ...)}
\item \code{delete_by_id(ids, name, commit = TRUE, commit_within = NULL, overwrite = TRUE, boost = NULL, wt = 'json', raw = FALSE, ...)}
\item \code{delete_by_query(query, name, commit = TRUE, commit_within = NULL, overwrite = TRUE, boost = NULL, wt = 'json', raw = FALSE, ...)}
\item \code{update_json(files, name, commit = TRUE, optimize = FALSE, max_segments = 1, expunge_deletes = FALSE, wait_searcher = TRUE, soft_commit = FALSE, prepare_commit = NULL, wt = 'json', raw = FALSE, ...)}
\item \code{update_xml(files, name, commit = TRUE, optimize = FALSE, max_segments = 1, expunge_deletes = FALSE, wait_searcher = TRUE, soft_commit = FALSE, prepare_commit = NULL, wt = 'json', raw = FALSE, ...)}
\item \code{update_csv(files, name, separator = ',', header = TRUE, fieldnames = NULL, skip = NULL, skipLines = 0, trim = FALSE, encapsulator = NULL, escape = NULL, keepEmpty = FALSE, literal = NULL, map = NULL, split = NULL, rowid = NULL, rowidOffset = NULL, overwrite = NULL, commit = NULL, wt = 'json', raw = FALSE, ...)}
\item \code{update_atomic_json(body, name, wt = 'json', raw = FALSE, ...)}
\item \code{update_atomic_xml(body, name, wt = 'json', raw = FALSE, ...)}
}
}

\examples{
\dontrun{
# make a client
(cli <- SolrClient$new())

# variables
cli$host
cli$port
cli$path
cli$scheme

# ping
## ping to make sure it's up
cli$ping("gettingstarted")

# version
## get Solr version information
cli$schema("gettingstarted")
cli$schema("gettingstarted", "fields")
cli$schema("gettingstarted", "name")
cli$schema("gettingstarted", "version")$version

# Search
cli$search("gettingstarted", params = list(q = "*:*"))
cli$search("gettingstarted", body = list(query = "*:*"))

# set a different host
SolrClient$new(host = 'stuff.com')

# set a different port
SolrClient$new(host = 3456)

# set a different http scheme
SolrClient$new(scheme = 'https')

# set a proxy
SolrClient$new(proxy = list(url = "187.62.207.130:3128"))

prox <- list(url = "187.62.207.130:3128", user = "foo", pwd = "bar")
cli <- SolrClient$new(proxy = prox)
cli$proxy

# A remote Solr instance to which you don't have admin access
(cli <- SolrClient$new(host = "api.plos.org", path = "search", port = NULL))
cli$search(params = list(q = "memory"))
}
}
\keyword{datasets}
