% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominance.R
\name{dominates}
\alias{dominates}
\title{Domination}
\usage{
dominates(powerRelation, e1, e2, strictly = FALSE, includeEmptySet = TRUE)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}

\item{e1, e2}{Elements in \code{powerRelation$elements}}

\item{strictly}{If TRUE, check if \code{p1} \emph{strictly} dominates \code{p2}}

\item{includeEmptySet}{If \code{TRUE}, check \mjeqn{\lbrace i \rbrace \succeq \lbrace j \rbrace}{\{i\} >= \{j\}} even if
empty set is not part of the power relation.}
}
\value{
Logical value \code{TRUE} if \code{e1} dominates \code{e2}, else \code{FALSE}.
}
\description{
Test if one element dominates the other.
}
\details{
\loadmathjax
\mjseqn{i} is said to dominate \mjseqn{j}, if
\mjeqn{S \cup \lbrace i \rbrace \succeq S \cup \lbrace j \rbrace}{Sn\{i\} >= Sn\{j\}} for all
\mjeqn{S \in 2^{N \setminus \lbrace i,j \rbrace}}{S in 2^(N-\{i,j\})}.

\mjseqn{i} \emph{strictly} dominates \mjseqn{j}, if there exists one
\mjeqn{S \in 2^{N \setminus \lbrace i,j \rbrace}}{S in 2^(N-\{i,j\})} such that
\mjeqn{S \cup \lbrace i \rbrace \succ S \cup \lbrace j \rbrace}{Sn\{i\} > Sn\{j\}}.
}
\examples{
pr <- newPowerRelationFromString("12 > 1 > 2", asWhat = as.numeric)

# TRUE
d1 <- dominates(pr, 1, 2)

# FALSE
d2 <- dominates(pr, 2, 1)

# TRUE (because it's not strict dominance)
d3 <- dominates(pr, 1, 1)

# FALSE
d4 <- dominates(pr, 1, 1, strictly = TRUE)

stopifnot(all(d1, !d2, d3, !d4))

}
