% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{aux_pexp}
\alias{aux_pexp}
\title{Mean of a (Powered Exponential) covariance function (Internal use)}
\usage{
aux_pexp(dist, sigsq, phi, nu)
}
\arguments{
\item{sigsq}{the \eqn{\sigma^2} parameter from the Powered Exponential
covariance function.}

\item{phi}{the \eqn{\phi} parameter from the Powered Exponential covariance
function, controls the range of the spatial dependence.}

\item{nu}{the \eqn{\nu} parameter from the Powered Exponential
covariance function,
controls the differentiability of the process.}

\item{dists}{a numeric matrix representing the distance between spatial
entities.}
}
\value{
The mean of \code{pexp_cov(dist, sigsq, phi, nu)}.
}
\description{
This is an auxilliary function for internal use. It helps to
numerically integrate a covariance function evaluated at a grid of points
within a polyigon and speed-up the computations.
}
\keyword{internal}
