% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.poisson.adj.R
\name{stat.poisson.adj}
\alias{stat.poisson.adj}
\alias{stat_poisson_adj}
\alias{stat_binom_adj}
\title{Compute Poisson test statistic}
\usage{
stat.poisson.adj(
  yin,
  ty,
  logein,
  logeout,
  a = 0,
  pen = 1,
  min.cases = 2,
  return.max = FALSE
)

stat_poisson_adj(
  yin,
  ty,
  logein,
  logeout,
  a = 0,
  pen = 1,
  min.cases = 2,
  return.max = FALSE
)

stat_binom_adj(
  yin,
  ty,
  popin,
  popout,
  logpopin,
  logpopout,
  tpop,
  min.cases = 2,
  return.max = FALSE
)
}
\arguments{
\item{yin}{The total number of cases in the zone.}

\item{ty}{The total number of cases in the study area.}

\item{logein}{The \code{log} of the expected number of
cases in each candidate zone.}

\item{logeout}{The \code{log} of the expected number of
cases outside of each candidate zone.}

\item{a}{A tuning parameter for the adjusted
log-likelihood ratio.  See details.}

\item{pen}{The eccentricity penalty for each candidate
zone.}

\item{min.cases}{The minimum number of cases required for
a cluster.  The default is 2.}

\item{return.max}{A logical value. Default is \code{FALSE}. If
\code{TRUE}, then only the maximum statistic is returned.}

\item{popin}{The total population in the zone.}

\item{popout}{The population outside the zone.  This
should be \code{tpop - popin} and is computed
automatically if not provided.}

\item{logpopin}{The \code{log} of the population in each
candidate zone.}

\item{logpopout}{The \code{log} of the population outside
of each candidate zone.}

\item{tpop}{The total population in the study area.}
}
\value{
A numeric vector.
}
\description{
Efficiently compute a vector of Poisson test statistics.
This function does no sanity checking. We encourage you
to compare the results against
\code{\link[smerc]{scan.stat}} for correctness.
\code{stat_poisson_adj} is a C++ version implementation
of the code and should be faster.
\code{stat_binomial_adj} is a C++ version implementation
of \code{\link[smerc]{stat.binom}}.
}
\examples{
data(nydf)
coords <- with(nydf, cbind(longitude, latitude))
enn <- elliptic.nn(coords, nydf$pop, ubpop = 0.015)
cases <- floor(nydf$cases)
ty <- sum(cases)
ex <- ty / sum(nydf$pop) * nydf$pop
yin <- nn.cumsum(enn$nn, cases)
ein <- nn.cumsum(enn$nn, ex)
logein <- log(ein)
logeout <- log(ty - ein)
pen <- elliptic.penalty(a = 0.5, enn$shape_all)
stat.poisson.adj(yin, ty, logein, logeout,
  a = 0.5, pen = pen, return.max = TRUE
)
}
\keyword{internal}
