% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bn.test.R
\name{bn.test}
\alias{bn.test}
\title{Besag-Newell Test}
\usage{
bn.test(coords, cases, pop, cstar, alpha = 0.1, lonlat = FALSE,
  noc = TRUE, modified = FALSE)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid coordinates for the regions.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each region.}

\item{cstar}{A non-negative integer indicating the 
minimum number of cases to include in each window.}

\item{alpha}{The significance level to determine whether a cluster is signficant.  Default is \code{0.10}.}

\item{lonlat}{The default is \code{FALSE}, which specifies that Euclidean distance should be used.If \code{lonlat} is \code{TRUE}, then the great circle distance is used to calculate the intercentroid distance.}

\item{noc}{A logical value indicating whether all significant 
clusters should be returned (\code{FALSE}) or only the 
non-overlapping clusters (\code{TRUE}) arranged in 
order of significance.  The default is \code{TRUE}.}

\item{modified}{A logical value indicating whether a 
modified version of the test should be performed.  The 
original paper recommends computing the p-value for each
cluster as \code{1 - ppois(cstar - 1, lambda = expected)}.
The modified version replaces \code{cstar} with 
\code{cases}, the observed number of cases in the region, 
and computes the p-value for the cluster as 
\code{1 - ppois(cases - 1, lambda = ex)}.
The default is \code{modified = FALSE}.}
}
\value{
Returns a list of length two of class \code{scan}. The first element (clusters) is a list containing the significant clusters and has the the following components: 
\item{locids}{The location ids of regions in a significant cluster.}
\item{coords}{The centroid of the initial region.}
\item{r}{The maximum radius of the cluster (in terms of intercentroid distance from the starting region).}
\item{pop}{The total population in the cluser window.}
\item{cases}{The observed number of cases in the cluster window.}
\item{expected}{The expected number of cases in the cluster window.}
\item{smr}{Standarized mortaility ratio (observed/expected) in the cluster window.}
\item{rr}{Relative risk in the cluster window.}
\item{tstat}{The loglikelihood ratio for the cluster window (i.e., the log of the test statistic).}
\item{pvalue}{The pvalue of the test statistic associated with the cluster window.}
\item{w}{The adjacency matrix of the cluster.}
The second element of the list is the centroid coordinates.  This is needed for plotting purposes.
}
\description{
\code{bn.test} implements the Besag-Newell test of 
Besag and Newell (1991) for finding disease clusters.
}
\examples{
data(nydf)
data(nyw)
coords = with(nydf, cbind(x, y))
out = bn.test(coords = coords, cases = nydf$cases,
              pop = nydf$pop, cstar = 6, 
              alpha = 0.1)
plot(out)

data(nypoly)
library(sp)
plot(nypoly, col = color.clusters(out))
}
\references{
Besag, J. and Newell, J.  (1991). The detection of clusters in rare diseases, Journal of the Royal Statistical Society, Series A, 154, 327-333.
}
\seealso{
\code{\link{scan.stat}}, \code{\link{plot.scan}}, 
\code{\link{scan.test}}, \code{\link{flex.test}}, 
\code{\link{dmst.test}}, \code{\link{uls.test}},
\code{\link{mlf.test}}
}
\author{
Joshua French
}
