% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nn.R
\name{nn}
\alias{nn}
\title{Determine nearest neighbors}
\usage{
nn(d, k, method = "c", self = FALSE)
}
\arguments{
\item{d}{A square distance matrix for the set of coordinates of interest.}

\item{k}{The number of numbers to return (if \code{method = "c"}) or the distance for which observations are considered neighbors (if \code{method = "d"}).}

\item{method}{The method of determining the neighbors.  The default is \code{"c"}, specifying that the \code{k} nearest neighbors (the count of neighbors) for each observation should be returned.  The alternative is \code{"d"}, meaning that neighbors are determined by their distance from an observation.  In that case, two observations are neighbors if their separation distance is less or equal to \code{k}.}

\item{self}{A logical indicating whether an observation is a neighbor with itself.  The default is \code{FALSE}.}
}
\value{
Returns the indexes of the nearest neighbors as a matrix if \code{method = "c"} and a list otherwise.  For each row or element of the list, the indexes are ordered from nearest to farthest.
}
\description{
\code{nn} determines the nearest neighbors for a set of observations based on the distance matrix.
}
\details{
This function can determine nearest neighbors in two ways:  1. by total count or 2. by distance.
If method = "c", then k determines the total number of neighbors to return for each observation.
If method = "d", then k determines the distance for which an observation is considered a neighbor.
}
\examples{
data(grave)
# make distance matrix
d = as.matrix(dist(cbind(grave$x, grave$y)))
# 3 nearest neighbors
nnc = nn(d, k = 3, method = "c")
# nearest neighbors within k units of each observation
nnd = nn(d, k = 200, method = "d")
}
\author{
Joshua French
}

