% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_point_data.R
\name{get_lscape_point}
\alias{get_lscape_point}
\title{Get SLGA point landscape data}
\usage{
get_lscape_point(product = NULL, poi = NULL, buff = 0L,
  buff_shp = c("square", "circle"), stat = "median")
}
\arguments{
\item{product}{Character, one of the options from column 'Short_Name' in
\code{\link[slga:slga_product_info]{slga_product_info}}, where Type =
'Landscape'.}

\item{poi}{WGS84 coordinates defining a point of interest. Supply an
sf-style point object or a length-2 numeric vector (x, y).}

\item{buff}{Length-1 integer. Use if a summarised value around a point is desired.
Defaults to 0L, which returns the exact value(s) of the pixel under the `poi`.
A `buff` value of 1 will return a summary of the pixels in a one-cell range,
etc.}

\item{buff_shp}{One of 'square' or 'circle'. Use with buff > 0.
Defaults to 'square', in which case all values within the buffer are
summarised. A circular mask is applied to the data before summarising
otherwise.}

\item{stat}{Summary method applied where buff > 0. Defaults to median. Other
options include mean, modal, min, max, sd, IQR, quantile, and summary.}
}
\value{
An data.frame with requested values.
}
\description{
Get SLGA landscape covariate data at a point location.
}
\note{
If you have many points within a relatively small area, it will likely
be more efficient to grab a raster covering the whole area and extract
summary values yourself.
}
\examples{
\donttest{
 # get the slope at a point
 slope_pt <- get_lscape_point('SLPPC', c(153,-27.5))

 # get the average slope within ~300m of a point
 avg_slope <- get_lscape_point('SLPPC', c(153, -27.5),
                               buff = 3, buff_shp = 'circle', stat = 'mean')
     }
}
