% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netDir.R
\name{make.netDir}
\alias{make.netDir}
\title{Directed network}
\usage{
make.netDir(x, disp = FALSE, cap = FALSE, alpha = 0.003, pct = 10,
  carrier = FALSE, metro = FALSE)
}
\arguments{
\item{x}{Data frame}

\item{disp}{Uses the Serrano's disparity filter (\url{https://en.wikipedia.org/wiki/Disparity_filter_algorithm_of_weighted_network})
to extract the backbone of the network.}

\item{cap}{Filters original data based on the edge weight.}

\item{alpha}{Argument for disparity filter.}

\item{pct}{Argument for cap filter. Value should be imput as percentage.}

\item{carrier}{Groups data per carrier and OD}

\item{metro}{Groups data by metropolitan area (not compatible with plot)}
}
\description{
Generates Directed Network with an iGraph object and a Data Frame.
}
\examples{
\dontrun{
make.netDir(OD_sample)

# Apply Disparity Filter
make.netDir(OD_sample, disp = TRUE, alpha = 0.05)

# Apply Percentage Cap
make.netDir(OD_sample, cap = TRUE, pct = 20)
}
}
