% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{arrange_ids}
\alias{arrange_ids}
\title{Order IDs across two columns}
\usage{
arrange_ids(.data, .id1, .id2)
}
\arguments{
\item{.data}{A tibble with two ID columns to arrange.}

\item{.id1}{Unquoted name of the "id1" column. See examples.}

\item{.id2}{Unquoted name of the "id2" column. See examples.}
}
\value{
A tibble with id1 and id2 rearranged alphanumerically.
}
\description{
Some types of data or results are indexed by two identifiers in
two different columns corresponding to data points for \emph{pairs} of
observations. E.g., you may have columns called \code{id1} and \code{id2} that index
the tibble for all possible pairs of results between samples A, B, and C.
If you attempt to join two tibbles with \code{by=c("id1", "id2")}, the join will
fail if samples are flipped from one dataset to another. E.g., one tibble
may have id1=A and id2=B while the other has id1=B and id2=A. This function
ensures that id1 is alphanumerically first while id2 is alphanumerically
second. See examples.
}
\examples{
d1 <- tibble::tribble(
  ~id1, ~id2, ~results1,
  "a",  "b",       10L,
  "a",  "c",       20L,
  "c",  "b",       30L
)
d2 <- tibble::tribble(
  ~id1, ~id2,  ~results2,
  "b",  "a",       101L,
  "c",  "a",       201L,
  "b",  "c",       301L
)
# Inner join fails because id1!=id2.
dplyr::inner_join(d1, d2, by=c("id1", "id2"))
# Arrange IDs
d1 \%>\% arrange_ids(id1, id2)
d2 \%>\% arrange_ids(id1, id2)
# Inner join
dplyr::inner_join(arrange_ids(d1, id1, id2), arrange_ids(d2, id1, id2), by=c("id1", "id2"))
# Recursively, if you had more than two tibbles
list(d1, d2) \%>\%
  purrr::map(arrange_ids, id1, id2) \%>\%
  purrr::reduce(dplyr::inner_join, by=c("id1", "id2"))
}
