% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicho.R
\name{dicho}
\alias{dicho}
\title{Dichotomize variables}
\usage{
dicho(x, dich.by = "median", as.num = FALSE, var.label = NULL,
  val.labels = NULL, suffix = "_d")
}
\arguments{
\item{x}{A variable, data frame or list-object.}

\item{dich.by}{Indicates the split criterion where a variable is dichotomized.
Must be one of the following values (may be abbreviated):
\describe{
  \item{\code{"median"} or \code{"md"}}{by default, \code{x} is split into two groups at the median.}
  \item{\code{"mean"} or \code{"m"}}{splits \code{x} into two groups at the mean of \code{x}.}
  \item{numeric value}{splits \code{x} into two groups at the specific value. Note that the value is inclusive, i.e. \code{dich.by = 10} will split \code{x} into one group with values from lowest to 10 and another group with values greater than 10.}
  }}

\item{as.num}{Logical, if \code{TRUE}, return value will be numeric, not a factor.}

\item{var.label}{Optional string, to set variable label attribute for the
returned variable (see \code{\link{set_label}}). If \code{NULL}
(default), variable label attribute of \code{x} will be used (if present).
If empty, variable label attributes will be removed.}

\item{val.labels}{Optional character vector (of length two), to set value label
attributes of dichotomized variable (see \code{\link{set_labels}}).
If \code{NULL} (default), no value labels will be set.}

\item{suffix}{String value, will be appended to variable (column) names of
\code{x}, if \code{x} is a data frame. If \code{x} is not a data
frame, this argument will be ignored. The default value to suffix
column names in a data frame depends on the function call:
\itemize{
  \item recoded variables (\code{rec()}) will be suffixed with \code{"_r"}
  \item dichotomized variables (\code{dicho()}) will be suffixed with \code{"_d"}
  \item grouped variables (\code{split_var()}) will be suffixed with \code{"_g"}
}}
}
\value{
A dichotomized factor (or numeric, if \code{as.num = TRUE}) variable (0/1-coded),
          respectively a data frame or list of dichotomized factor (or numeric) variables.
}
\description{
Dichotomizes variables into dummy variables (0/1). Dichotomization is
               either done by median, mean or a specific value (see \code{dich.by}).
               Either single vectors, a complete data frame or a list of
               variables can be dichotomized.
}
\note{
Variable label attributes are preserved (unless changes via
      \code{var.label}-argument).
}
\examples{
data(efc)
summary(efc$c12hour)
# split at median
table(dicho(efc$c12hour))
# split at mean
table(dicho(efc$c12hour, "mean"))
# split between value lowest to 30, and above 30
table(dicho(efc$c12hour, 30))

# sample data frame, values from 1-4
head(efc[, 6:10])

# dichtomized values (1 to 2 = 0, 3 to 4 = 1)
library(dplyr)
efc \%>\%
  select(6:10) \%>\%
  dicho(dich.by = 2) \%>\%
  head()

# dichtomize several variables in a list
dummy <- list(efc$c12hour, efc$e17age, efc$c160age)
dicho(dummy)

# dichotomize and set labels
frq(dicho(efc$e42dep, var.label = "Dependency (dichotomized)",
          val.labels = c("lower", "higher")))

}

