% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_empty.R
\name{is_empty}
\alias{is_empty}
\title{Check whether string or vector is empty}
\usage{
is_empty(x)
}
\arguments{
\item{x}{String, character vector of length 1, or vector.}
}
\value{
Logical, \code{TRUE} if \code{x} is a character vector or string and
          is empty, \code{TRUE} if \code{x} is any vector and of length 0,
          \code{FALSE} otherwise.
}
\description{
This function checks whether a string or character vector (of
               length 1) or any vector (numeric, atomic) is empty or not.
}
\note{
\code{NULL}- or \code{NA}-values are also considered as "empty" (see
        'Examples') and will return \code{TRUE}.
}
\examples{
x <- "test"
is_empty(x)

x <- ""
is_empty(x)

x <- NA
is_empty(x)

x <- NULL
is_empty(x)

# string is not empty
is_empty(" ")

# however, this trimmed string is
is_empty(trim(" "))

# numeric vector
x <- 1
is_empty(x)
x <- x[-1]
is_empty(x)

}

