% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotScatter.R
\name{sjp.scatter}
\alias{sjp.scatter}
\title{Plot (grouped) scatter plots}
\usage{
sjp.scatter(x = NULL, y = NULL, grp = NULL, title = "",
  legendTitle = NULL, legendLabels = NULL, pointLabels = NULL,
  axisTitle.x = NULL, axisTitle.y = NULL, breakTitleAt = 50,
  breakLegendTitleAt = 20, breakLegendLabelsAt = 20, geom.size = 3,
  geom.colors = NULL, showTickMarkLabels.x = TRUE,
  showTickMarkLabels.y = TRUE, showGroupFitLine = FALSE,
  showTotalFitLine = FALSE, show.se = FALSE, fitmethod = "lm",
  useJitter = FALSE, autojitter = TRUE, jitterRatio = 0.15,
  showRug = FALSE, hideLegend = FALSE, facet.grid = FALSE,
  printPlot = TRUE)
}
\arguments{
\item{x}{vector indicating the x positions. If not specified (i.e. if
\code{NULL}), a range from 1 to length of \code{y} is used to spread the
dots along the x axis.}

\item{y}{vector indicating the y positions. If not specified (i.e. if
\code{NULL}), a range from 1 to length of \code{x} is used to spread the
dots along the y axis.}

\item{grp}{grouping variable. If not \code{NULL}, the scatter plot will be grouped. See
'Examples'. Default is \code{NULL}, i.e. not grouping is done.}

\item{title}{plot title as string. Example: \code{title = "my title"}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details). If \code{title = ""},
no title is printed.}

\item{legendTitle}{title of the plot legend, as string.}

\item{legendLabels}{a character vector with labels for the guide/legend.}

\item{pointLabels}{character vector with names for each coordinate pair given
by \code{x} and \code{y}, so instead of dots, text labels are
printed to the plot. Must be of same length as \code{x} and \code{y}.
If \code{pointLabels} has a different length, data points will be trimmed
to match \code{pointLabels}. If \code{pointLabels = NULL} (default),
dots instead of labels are printed.}

\item{axisTitle.x}{title for the x axis. Use \code{NULL} to automatically
detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details).}

\item{axisTitle.y}{title for the y axis.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details).}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLegendTitleAt}{determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{breakLegendLabelsAt}{determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{geom.size}{size of point geoms.}

\item{geom.colors}{color(s) of point geoms. If \code{grp} is not \code{NULL},
groups are indicated by different colors, thus a vector with multiple
color values has to be supplied.}

\item{showTickMarkLabels.x}{logica, whether x axis tick mark labels should be shown or not.}

\item{showTickMarkLabels.y}{logical, hether y axis tick mark labels  should be shown or not.}

\item{showGroupFitLine}{logical, if \code{TRUE}, a fitted line for each group
is drawn. See \code{fitmethod} to change the fit method of the fitted lines.}

\item{showTotalFitLine}{logical, if \code{TRUE}, a fitted line for the overall
scatterplot is drawn. See \code{fitmethod} to change the fit method
of the fitted line.}

\item{show.se}{logical, if \code{TRUE}, a shaded region indicating the standard error of the fitted lines will be added.}

\item{fitmethod}{By default, a linear method (\code{"lm"}) is used for fitting
the fit lines. Possible values are for instance \code{"lm"}, \code{"glm"},
\code{"loess"} or \code{"auto"}
(see \href{http://docs.ggplot2.org/current/stat_smooth.html}{ggplot-docs}
for more details).}

\item{useJitter}{logical, if \code{TRUE}, points will be jittered (to avoid overplotting).}

\item{autojitter}{logical, if \code{TRUE}, points will be jittered according
to an overlap-estimation. A matrix of \code{x} and \code{y} values
is created and the amount of cells (indicating a unique point position)
is calculated. If more than 15\% (see \code{jitterRatio}) of the
approximated amount of unique point coordinates seem to
overlap, they are automatically jittered.}

\item{jitterRatio}{ratio of tolerated overlapping (see \code{autojitter}).
If approximated amount of overlapping  points exceed this ratio,
they are automatically jittered. Default is 0.15. Valid values range
between 0 and 1.}

\item{showRug}{logical, if \code{TRUE}, a marginal rug plot is displayed
in the graph (see \href{http://docs.ggplot2.org/current/geom_rug.html}{ggplot-docs}
for more details).}

\item{hideLegend}{logical, indicates whether legend (guide) should be shown or not.}

\item{facet.grid}{\code{TRUE} when each scatter plot group should be plotted as single facet instead of
an integrated single graph. Only applies if \code{grp} is not \code{NULL}. Each category of
\code{grp} will be plotted in an own facet.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Display scatter plot of two variables. Adding a grouping variable to
               the scatter plot is possible. Furthermore, fitted lines can be added
               for each group as well as for the overall plot.
}
\examples{
# load sample date
library(sjmisc)
data(efc)

# simple scatter plot, auto-jittering
sjp.scatter(efc$e16sex, efc$neg_c_7)

# simple scatter plot, no jittering needed
sjp.scatter(efc$c160age, efc$e17age)

# grouped scatter plot
sjp.scatter(efc$c160age, efc$e17age, efc$e42dep)

# grouped and jittered scatter plot with marginal rug plot
sjp.scatter(efc$e16sex,efc$neg_c_7, efc$c172code, showRug = TRUE)

# grouped and labelled scatter plot, not using the auto-detection
# of labels, but instead pass labels as arguments
sjp.scatter(efc$c160age, efc$e17age, efc$e42dep,
            title = "Scatter Plot",
            legendTitle = get_label(efc)['e42dep'],
            legendLabels = get_labels(efc)[['e42dep']],
            axisTitle.x = get_label(efc)['c160age'],
            axisTitle.y = get_label(efc)['e17age'],
            showGroupFitLine = TRUE)

# grouped and labelled scatter plot as facets
sjp.scatter(efc$c160age,efc$e17age, efc$e42dep,
            showGroupFitLine = TRUE,
            facet.grid = TRUE,
            show.se = TRUE)

# plot residuals of fitted models
fit <- lm(neg_c_7 ~ quol_5, data = efc)
sjp.scatter(y = fit$residuals, showTotalFitLine = TRUE)

# "hide" axis titles
sjp.scatter(efc$c160age, efc$e17age, efc$e42dep,
            title = "", axisTitle.x = "", axisTitle.y = "")

# plot text labels
pl <- c(1:10)
for (i in 1:10) pl[i] <- paste(sample(c(0:9, letters, LETTERS),
                                      8, replace = TRUE),
                               collapse = "")
sjp.scatter(runif(10), runif(10), pointLabels = pl)
}
\seealso{
\href{http://www.strengejacke.de/sjPlot/sjp.scatter}{sjPlot manual: sjp.scatter}
}

