% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.segments}
\alias{plot.segments}
\title{Plot Segments}
\usage{
\method{plot}{segments}(
  x,
  ...,
  tile = NULL,
  legend = NULL,
  color_palette = "Spectral",
  tmap_options = NULL
)
}
\arguments{
\item{x}{Object of class "segments".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{legend}{Named vector that associates labels to colors.}

\item{color_palette}{Alternative RColorBrewer palette}

\item{tmap_options}{List with optional tmap parameters
tmap_max_cells (default: 1e+06)
tmap_graticules_labels_size (default: 0.7)
tmap_legend_title_size (default: 1.5)
tmap_legend_text_size (default: 1.2)
tmap_legend_bg_color (default: "white")
tmap_legend_bg_alpha (default: 0.5)}
}
\value{
A plot object with an RGB image
                      or a B/W image on a color
                      scale using the pallete
}
\description{
Plot RGB raster cube
}
\note{
To see which color palettes are supported, please run
}
\examples{
if (sits_run_examples()) {
data_dir <- system.file("extdata/raster/mod13q1", package = "sits")

cube <- sits_cube(
    source = "BDC",
    collection = "MOD13Q1-6",
    data_dir = data_dir
)

# segment the image
segments <- sits_segment(
    cube = cube,
    tile = "012010",
    bands = "NDVI",
    date = sits_timeline(cube)[1],
    seg_fn = sits_slic(step = 10)
)
# create a classification model
rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
# get the average value per segment
samples_seg <- sits_get_data(
    cube = cube,
    samples = segments
)
# classify the segments
seg_class <- sits_classify(
    data = samples_seg,
    ml_model = rfor_model
)
# add a column to the segments by class
sf_seg <- sits_join_segments(
    data = seg_class,
    segments = segments
)
plot(sf_seg)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
