% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_debug.R
\name{sits_debug_log}
\alias{sits_debug_log}
\alias{.sits_debug_log}
\alias{.sits_debug}
\title{sits log functions}
\usage{
.sits_debug_log(output_dir = ".", event = "", key = "", value = "")

.sits_debug(flag = NULL)
}
\arguments{
\item{output_dir}{Output directory to write log file}

\item{event}{The name of the event to be logged}

\item{key}{A key describing the value.}

\item{value}{Any value to be logged. The value will be converted
to string and escaped.}

\item{flag}{A logical value to set the debug flag}
}
\value{
A logical value with current debug flag
}
\description{
.sits_debug_log: (internal) logs to a CSV file the following values:
\itemize{
\item date_time: event date and time
\item pid: process identifier
\item event: event name
\item elapsed_time: duration (in seconds) from the last log call
\item mem_used: session used memory (in MB)
\item max_mem_used: maximum memory used (in MB) from first log call
\item tag: any character string to be registered
}
Each event will be logged in one row in the log file.
The log file name will be the same as the base name of the current
session's temporary directory.

.sits_debug: When called without parameters retrieves the
current debug flag value. The sits write log files when the debug
flag is TRUE
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
\keyword{internal}
