% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_sistec.R
\name{compare_sistec}
\alias{compare_sistec}
\title{Comparison between Sistec and a student registration dataset}
\usage{
compare_sistec(sistec, student_registration)
}
\arguments{
\item{sistec}{The folder's path to Sistec files or the Sistec data frame
read by \code{sistec::read_sistec()}function.}

\item{student_registration}{The folder's path to students reagistration datasets or a
data frame read by \verb{sistec::read_*()}functions.}
}
\value{
A list of data frames.
}
\description{
A generic function to compare and save the student situation. This function also
shows inconsistencies in the datasets. You can pass the folder's file path or
a data frame read by \verb{sistec::read_*()} functions.
}
\examples{
# these datasets are not real. It is just for test purpose.
qacademico <- read_qacademico(system.file("extdata/examples/qacademico",
                                          package = "sistec"))
sistec <- read_sistec(system.file("extdata/examples/sistec",
                                  package = "sistec"))
                                  
compare_sistec(sistec, qacademico)                                   

}
