% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDataset.R
\name{createDataset}
\alias{createDataset}
\title{Create a Dataset for Choice Experiment Analysis}
\usage{
createDataset(design, respondents)
}
\arguments{
\item{design}{A data frame containing the design matrix for the choice experiment.
It should include at least the columns \code{Choice.situation} and optionally \code{Block}.}

\item{respondents}{The number of respondents to generate data for.}
}
\value{
A data frame containing the augmented design matrix with additional columns:
\describe{
\item{ID}{A unique identifier for each respondent.}
\item{Choice.situation}{The original choice situations, replicated for respondents.}
\item{Other columns}{All original columns in the input \code{design} are retained.}
}
}
\description{
This function takes a design matrix and generates a dataset for use in choice experiments.
It handles blocks, replicates the design for the number of respondents, and assigns respondent IDs.
}
\details{
The function performs the following steps:
\itemize{
\item Checks if the \code{Block} column exists in the input design. If absent, it creates a single block.
\item Calculates the number of choice sets and blocks, and determines the number of sets per block.
\item Replicates the design to account for the specified number of respondents per block.
\item Assigns respondent IDs based on the number of respondents and blocks.
}
}
\examples{
# Example usage:
design <- data.frame(
  Choice.situation = rep(1:12),
  Attribute1 = rnorm(12),
  Attribute2 = sample(1:3, 12, replace = TRUE)
)
result <- createDataset(design, 10)
}
