% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAvgTemp.R
\name{plotAvgTemp}
\alias{plotAvgTemp}
\title{Plot average temperature}
\usage{
plotAvgTemp(
  mydata,
  date = "date",
  temp = "temp",
  avg.time = "1 month",
  ylabel = NULL,
  title = "",
  locale = NULL
)
}
\arguments{
\item{mydata}{A dataframe containing data to plot.}

\item{date}{The name of the column representing date and time. Data must be of
class \code{POSIXlt} or \code{POSIXct} (default = "date"). If timezone is unspecified,
it is set to GMT.}

\item{temp}{Name of the column representing temperature (default = "temp")}

\item{avg.time}{Defines the time period to average to.
Currently the only supported period is "1 month" (default).}

\item{ylabel}{The label along the y axis.
If missing a default label is plotted.}

\item{title}{Optional plot title}

\item{locale}{Locale to use for day and month names. Default is current
locale. Supported locales are listed in stringi::stri_locale_list().
All other labels are in English by default or in Italian if its locale is
specified.}
}
\value{
A plot with average, min and max temperature in a given
range of time.
}
\description{
\code{plotAvgTemp} builds a bar plot of time average temperature and two
line plots with maximum and minimum temperature.
}
\examples{
# Plot average monthly temperature and curves with monthly maximum and minimum
data(stMeteo)
str(stMeteo)
plotAvgTemp(stMeteo)
# Add a custom title
plotAvgTemp(stMeteo, title = "Monthly temperature")

# Override default locale
plotAvgTemp(stMeteo, avg.time = "1 month", locale = "it_IT")

}
\seealso{
\code{\link[=plotStabilityClass]{plotStabilityClass()}}, \code{\link[=plotAvgRad]{plotAvgRad()}}
}
