#' German breast cancer dataset
#'
#' A data set containing a subset of variables from the German
#' breast cancer study (Schumacher et al. (1994)).
#'
#' \itemize{
#'   \item \code{id} Subject ID
#'   \item \code{hormon} Treatment indicator for hormone therapy (0 = no, 1 = yes)
#'   \item \code{rectime} Time to recurrence or censoring (in days)
#'   \item \code{censrec} Event indicator (0 = censored, 1 = recurrence)
#' }
#'
#' @format A data frame with 686 rows and 4 variables.
#'
#' @references
#'
#' Sauerbrei W, Royston P. Building multivariable prognostic and diagnostic models:
#' transformation of the predictors by using fractional polynomials.
#' \emph{Journal of the Royal Statistics Society Series A}. 1999;\strong{162}(1):71--94.
#'
#' Schumacher M, et al. for the German Breast Cancer Study Group. Randomized 2x2
#' trial evaluating hormonal treatment and the duration of chemotherapy in
#' node-positive breast cancer patients. \emph{Journal of Clinical Oncology}.
#' 1994;\strong{12}:2086--2093.
#'
"brcancer"
