% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{simrOptions}
\alias{simrOptions}
\alias{getSimrOption}
\title{Options Settings for \code{simr}}
\usage{
simrOptions(...)

getSimrOption(opt)
}
\arguments{
\item{...}{a list of names to get options, or a named list of new values to set options.}

\item{opt}{option name (character string).}
}
\value{
\code{getSimrOption} returns the current value for the option \code{x}.

\code{simrOptions} returns

\enumerate{
\item a named list of all options, if no arguments are given.
\item a named list of specified options, if a list of option names is given.
\item (invisibly) a named list of changed options with their previous values, if options are set.
}
}
\description{
Control the default behaviour of \code{simr} analyses.
}
\section{Options in \code{simr}}{


Options that can be set with this method (and their default values).

\describe{
  \item{\code{nsim}}{default number of simulations (\code{1000}).}
  \item{\code{alpha}}{default confidence level (\code{0.05}).}
  \item{\code{progress}}{use progress bars during calculations (\code{TRUE}).}
  \item{\code{binom}}{method for calculating confidence intervals (\code{"exact"}).}
  \item{\code{pbnsim}}{number of simulations for parametric bootstrap tests using \code{pbkrtest} (\code{100}).}
  \item{\code{pcmin}}{minimum number of levels for the smallest point on a \code{\link{powerCurve}} (3).}
  \item{\code{pcmax}}{maximum number of points on the default \code{\link{powerCurve}} (10).}
  \item{\code{observedPowerWarning}}{warn if an unmodified fitted model is used (TRUE).}
  \item{\code{carTestType}}{ type of test, i.e. type of sum of squares, for tests performed with \code{\link[=Anova]{car::Anova}} (\code{"II"}).}
  \item{\code{lmerTestDdf}}{ approximation to use for denominator degrees of
                            freedom for tests performed with
                            \code{\link[lmerTest:lmer]{lmerTest}}
                            (\code{"Satterthwaite"}). Note that setting this
                            option to \code{"lme4"} will reduce the
                            \code{lmerTest} model to an \code{lme4} model and
                            break functionality based on \code{lmerTest}.}
 \item{\code{lmerTestType}}{ type of test, i.e. type of sum of squares, for
                             F-tests performed with
                             \code{\link[lmerTest:anova.lmerModLmerTest]{lmerTest::anova.lmerModLmerTest}}
                             (\code{2}). Note that unlike the tests performed
                             with \code{car::Anova}, the test type must be
                             given as a number and not a character.}

}
}

\examples{

getSimrOption("nsim")
oldopts <- simrOptions(nsim=5)
getSimrOption("nsim")
simrOptions(oldopts)
getSimrOption("nsim")

}
