% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex_tree.R
\name{reindex}
\alias{reindex}
\title{reindexes vertex ids}
\usage{
reindex(st, ids)
}
\arguments{
\item{st}{a simplex tree.}

\item{ids}{vector of new vertex ids. See details.}
}
\description{
This function allows one to 'reorder' or 'reindex' vertex ids.
}
\details{
The \code{ids} parameter must be a sorted integer vector of new ids with length matching the 
number of vertices. The simplex tree is modified to replace the vertex label at index \code{i} with 
\code{ids}[i]. See examples.
}
\examples{
st <- simplex_tree()
st \%>\% insert(1:3) \%>\% print_simplices("tree")
# 1 (h = 2): .( 2 3 )..( 3 )
# 2 (h = 1): .( 3 )
# 3 (h = 0):
st \%>\% reindex(4:6) \%>\% print_simplices("tree")
# 4 (h = 2): .( 5 6 )..( 6 )
# 5 (h = 1): .( 6 )
# 6 (h = 0):
}
