% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_histogram.R
\name{gg_histogram_col_facet}
\alias{gg_histogram_col_facet}
\title{DEPRECATED. Histogram ggplot that is coloured and facetted.}
\usage{
gg_histogram_col_facet(
  data,
  x_var,
  col_var,
  facet_var,
  pal = NULL,
  pal_na = "#7F7F7F",
  pal_rev = FALSE,
  alpha_fill = 0.5,
  alpha_line = 1,
  size_line = 0.5,
  title = NULL,
  title_wrap = 80,
  subtitle = NULL,
  subtitle_wrap = 80,
  x_bins_n = 30,
  x_breaks_n = 2,
  x_expand = c(0, 0),
  x_labels = scales::label_comma(),
  x_title = NULL,
  x_title_wrap = 50,
  y_breaks_n = 3,
  y_expand = c(0, 0),
  y_labels = scales::label_comma(),
  y_title = NULL,
  y_title_wrap = 50,
  col_labels = snakecase::to_sentence_case,
  col_legend_none = FALSE,
  col_na_rm = FALSE,
  col_title = NULL,
  col_title_wrap = 25,
  facet_labels = snakecase::to_sentence_case,
  facet_na_rm = FALSE,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_rev = FALSE,
  facet_scales = "fixed",
  caption = NULL,
  caption_wrap = 80,
  theme = gg_theme(y_grid = TRUE)
)
}
\arguments{
\item{data}{A data frame in a structure to be transformed to histogram statistics. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x scale. Required input.}

\item{col_var}{Unquoted categorical variable to colour histogram areas. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{pal}{Character vector of hex codes.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{alpha_fill}{The opacity of the fill. Defaults to 0.5.}

\item{alpha_line}{The opacity of the outline. Defaults to 1.}

\item{size_line}{The size of the outlines of histogram areas.}

\item{title}{Title string.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 75.}

\item{subtitle}{Subtitle string.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 75.}

\item{x_bins_n}{Number of bins to aim for. Defaults to 30.}

\item{x_breaks_n}{For a numeric x variable, the desired number of intervals on the x scale, as calculated by the pretty algorithm. Defaults to 2.}

\item{x_expand}{A vector of range expansion constants used to add padding to the x scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{x_labels}{A function or named vector to modify x scale labels. If NULL, categorical variable labels are converted to sentence case. Use ggplot2::waiver() to keep x labels untransformed.}

\item{x_title}{X scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{y_breaks_n}{For a numeric y variable, the desired number of intervals on the y scale, as calculated by the pretty algorithm. Defaults to 4.}

\item{y_expand}{A vector of range expansion constants used to add padding to the y scale, as per the ggplot2 expand argument in ggplot2 scales functions.}

\item{y_labels}{A function or named vector to modify y scale labels. Use ggplot2::waiver() to keep y labels untransformed.}

\item{y_title}{y scale title string. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{col_labels}{A function or named vector to modify colour scale labels. Use ggplot2::waiver() to keep colour labels untransformed.}

\item{col_legend_none}{TRUE or FALSE of whether to remove the legend.}

\item{col_na_rm}{TRUE or FALSE of whether to include col_var NA values. Defaults to FALSE.}

\item{col_title}{Colour title string for the legend. Defaults to NULL, which converts to sentence case with spaces. Use "" if you would like no title.}

\item{col_title_wrap}{Number of characters to wrap the colour title to. Defaults to 25.}

\item{facet_labels}{A function or named vector to modify facet scale labels. Defaults to converting labels to sentence case. Use ggplot2::waiver() to keep facet labels untransformed.}

\item{facet_na_rm}{TRUE or FALSE of whether to include facet_var NA values. Defaults to FALSE.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_rev}{TRUE or FALSE of whether the facet variable variable is reversed. Defaults to FALSE.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{theme}{A ggplot2 theme.}
}
\value{
A ggplot object.
}
\description{
DEPRECATED. Histogram ggplot that is coloured and facetted.
}
\examples{
library(simplevis)
library(palmerpenguins)

gg_histogram_col_facet(penguins, 
                     x_var = body_mass_g, 
                     col_var = sex, 
                     facet_var = species, 
                     col_na_rm = TRUE)
                     
}
