% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{select}
\alias{select}
\title{Select a resource}
\usage{
select(.trj, resources, policy = c("shortest-queue", "round-robin",
  "first-available", "random"), id = 0)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{resources}{one or more resource names, or a callable object (a function) which
must return one or more resource names.}

\item{policy}{if \code{resources} is a character vector, this parameter determines
the criteria for selecting a resource among the set of policies available:
'shortest-queue' selects the least busy resource, 'round-robin' selects the resources
in order cyclically, 'first-available' selects the first resource available,
and 'random' selects one at random.}

\item{id}{selection identifier for nested usage.}
}
\value{
Returns the trajectory object.
}
\description{
Resource selector for a subsequent seize/release.
}
\seealso{
\code{\link{seize_selected}}, \code{\link{release_selected}},
\code{\link{set_capacity_selected}}, \code{\link{set_queue_size_selected}}.
}
