% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.arrivals.R, R/plot.attributes.R,
%   R/plot.resources.R, R/simmer.plot.R
\name{plot.mon}
\alias{plot.mon}
\alias{plot.arrivals}
\alias{plot.attributes}
\alias{plot.resources}
\title{Plot Methods for \code{simmer} Monitoring Statistics}
\usage{
\method{plot}{arrivals}(x, metric = c("activity_time", "waiting_time", "flow_time"), ...)

\method{plot}{attributes}(x, metric = NULL, keys, ...)

\method{plot}{resources}(x, metric = c("usage", "utilization"), names,
  items = c("queue", "server", "system"), steps = FALSE, limits = TRUE,
  ...)
}
\arguments{
\item{x}{a data frame of class \code{arrivals}/\code{attributes}/\code{resources}
(see \code{\link{get_mon}}).}

\item{metric}{specific metric to compute.}

\item{...}{unused.}

\item{keys}{attributes to plot (if left empty, all attributes are shown).}

\item{names}{resources to plot (if left empty, all resources are shown).}

\item{items}{(\code{metric="usage"}) resource items to include in the chart.}

\item{steps}{(\code{metric="usage"}) whether to show the instantaneous usage
rather than the cumulative average.}

\item{limits}{(\code{metric="usage"}) whether to show limits.}
}
\value{
Returns a ggplot2 object.
}
\description{
Methods for the \code{\link{plot}} generic. See below for details about each
metric available.
}
\details{
The S3 method for 'arrivals' provides three metrics: \code{"activity_time"},
\code{"waiting_time"}, and \code{"flow_time"}. The \code{"activity_time"} is
the amount of time spent in active state (i.e., in \code{timeout} activities),
and it is already provided in the output of \code{get_mon_arrivals}. The
\code{"flow_time"} is the amount of time spent in the system, and it is
computed as follows: \code{flow = end_time - start_time}. Finally, the
\code{"waiting_time"} is the amount of time spent waiting (e.g., in resources'
queues, or due to a \code{wait} activity...), and it is computed as follows:
\code{waiting_time = flow_time - activity_time}. This method does not apply
any summary, but just shows a line plot of the values throughout the simulation.

The S3 method for 'attributes' does not support any metric. It simply
shows a stairstep graph of the values throughout the simulation for the keys
provided (or all the collected attributes if no key is provided).

The S3 method for 'resources' provides two metrics: \code{"usage"}
and \code{"utilization"}. The \code{"usage"} metric shows a line graph of
the cumulative average resource usage throughout the simulation, for each
resource, replication and item (by default, queue, server and system, which
is the sum of queue and server). If \code{steps=TRUE}, a stairstep graph with
the instantaneous values is provided instead. The \code{"utilization"} metric
shows a bar plot of the average resource utilization (total time in use
divided by the total simulation time). For multiple replications, the bar
represents the median, and the error bars represent the quartiles. Thus, if
a single replication is provided, the bar and the error bar coincide.
}
\examples{
t0 <- trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)

env <- simmer("SuperDuperSim") \%>\%
  add_resource("nurse", 1) \%>\%
  add_resource("doctor", 2) \%>\%
  add_resource("administration", 1) \%>\%
  add_generator("patient", t0, function() rnorm(1, 10, 2)) \%>\%
  run(until=80)

resources <- get_mon_resources(env)
arrivals <- get_mon_arrivals(env)

plot(resources, metric="usage", "doctor", items = "server", steps = TRUE)
plot(resources, metric="utilization", c("nurse", "doctor", "administration"))
plot(arrivals, metric="waiting_time")

}
