% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spCdfplot.R
\name{spCdfplot}
\alias{getCdf}
\alias{panelSpCdfplot}
\alias{prepCdf}
\alias{prepCdf.data.frame}
\alias{prepCdf.default}
\alias{prepanelSpCdfplot}
\alias{spCdfplot}
\alias{spCdfplot.default}
\title{Plot weighted cumulative distribution functions}
\usage{
spCdfplot(inp, x, cond = NULL, approx = c(FALSE, TRUE), n = 10000,
  bounds = TRUE, ...)

panelSpCdfplot(x, y, approx, bounds = TRUE, ...)

prepanelSpCdfplot(x, y, ...)

getCdf(x, weights = NULL, cond = NULL, data, ..., name = "")

prepCdf(x, w, ..., name = "")

\method{prepCdf}{data.frame}(x, w, ..., name = "")

\method{prepCdf}{default}(x, w, ..., name = "")
}
\arguments{
\item{inp}{an object of class \code{\linkS4class{simPopObj}} containing
survey sample and synthetic population data.}

\item{x}{a character vector specifying the columns of data available in the
sample and the population (specified in input object 'inp') to be plotted.}

\item{cond}{an optional character vector (of length 1, if used) specifying
the conditioning variable.}

\item{approx}{logicals indicating whether approximations of the cumulative
distribution functions should be computed.  The default is to use
\code{FALSE} for the survey data and \code{TRUE} for the population data.}

\item{n}{integers specifying the number of points at which the
approximations take place (see \code{\link[stats:approxfun]{approx}}).  It
is used wherever \code{approx} is \code{TRUE}.}

\item{bounds}{a logical indicating whether vertical lines should be drawn at
0 and 1 (the bounds for cumulative distribution functions).}

\item{\dots}{further arguments to be passed to
\code{\link[lattice]{xyplot}}.}
}
\value{
An object of class \code{"trellis"}, as returned by
\code{\link[lattice]{xyplot}}.
}
\description{
Plot cumulative distribution functions, possibly broken down according to
conditioning variables and taking into account sample weights.
}
\details{
Weights are directly extracted from the input object \code{inp} and are
taken into account by adjusting the step height.  To be precise, the
weighted step height for an observation is defined as its weight divided by
the sum of all weights\eqn{\ ( w_{i} / \sum_{j = 1}^{n} w_{j} ).}{.}
}
\examples{
## these take some time and are not run automatically
## copy & paste to the R command line

set.seed(1234)  # for reproducibility
data(eusilcS)   # load sample data
\dontrun{
## approx. 20 seconds computation time
inp <- specifyInput(data=eusilcS, hhid="db030", hhsize="hsize",
  strata="db040", weight="db090")
simPop <- simStructure(data=inp, method="direct",
  basicHHvars=c("age", "rb090", "hsize", "pl030", "pb220a"))

# multinomial model with random draws
eusilcM <- simContinuous(simPop, additional="netIncome",
  regModel = ~rb090+hsize+pl030+pb220a,
  upper=200000, equidist=FALSE, nr_cpus=1)
class(eusilcM)

# plot results
spCdfplot(eusilcM, "netIncome", cond=NULL)
spCdfplot(eusilcM, "netIncome", cond="rb090", layout=c(1,2))
}
}
\author{
Andreas Alfons
}
\seealso{
\code{\link{spCdf}}, \code{\link[lattice]{xyplot}}
}
\keyword{hplot}
\keyword{internal}

