% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvExpand.R
\name{SurvExpand}
\alias{SurvExpand}
\title{Convert a data frame of non-equal interval continuous observations into
equal interval continuous observations}
\usage{
SurvExpand(data, GroupVar, Time, Time2, event, PartialData = TRUE,
  messages = TRUE)
}
\arguments{
\item{data}{a data frame.}

\item{GroupVar}{a character string naming the unit grouping variable.}

\item{Time}{a character string naming the variable with the interval start
time.}

\item{Time2}{a character string naming the variable with the interval end
time.}

\item{event}{a character string naming the event variable. Note: must be
numeric with 0 indicating no event.}

\item{PartialData}{logical indicating whether or not to keep only the
expanded data required to find the Cox partial likelihood.}

\item{messages}{logical indicating if you want messages returned while the
function is working.}
}
\value{
Returns a data frame where observations have been expanded into
equally spaced time intervals.
}
\description{
\code{SurvExpand} convert a data frame of non-equal interval continuous
observations into equal interval continuous observations. This is useful for
creating time-interactions with \code{\link{tvc}}.
}
\details{
The function primarily prepares data from the creation of accurate
time-interactions with the \code{\link{tvc}} command.
Note: the function will work best if your original time intervals are
recorded in whole numbers. It also currently does not support repeated
events data.
}
\examples{
# Load Golub & Steunenberg (2007) Data
data("GolubEUPData")

# Subset PURELY TO SPEED UP THE EXAMPLE
GolubEUPData <- GolubEUPData[1:500, ]

# Expand data
GolubEUPDataExpand <- SurvExpand(GolubEUPData, GroupVar = 'caseno',
                       Time = 'begin', Time2 = 'end', event = 'event')

}
\references{
Gandrud, Christopher. 2015. simPH: An R Package for Illustrating
Estimates from Cox Proportional Hazard Models Including for Interactive and
Nonlinear Effects. Journal of Statistical Software. 65(3)1-20.
}
\seealso{
\code{\link{tvc}}
}
\keyword{utilities}

