% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.balancing.R
\name{content.balancing}
\alias{content.balancing}
\title{Content balancing}
\usage{
content.balancing(
  bank,
  administered = NULL,
  content.names,
  content.props,
  content.items,
  met.content = "MCCAT"
)
}
\arguments{
\item{bank}{matrix with item parameters (a, b, c)}

\item{administered}{vector with administered items, \code{NULL} if it is the first
item (default)}

\item{content.names}{vector with the contents of the test}

\item{content.props}{desirable proportion of each content in test, in
the same order of \code{content.names}}

\item{content.items}{vector indicating the content of each item}

\item{met.content}{content balancing method
\itemize{
\item \code{MCCAT} (default): the function picks all subgroups with
proportions most distant  from desirable.
\item \code{CCAT}: if there is any subgroup without
administered item, the function will randomly pick one.
If all subgroups has at least one applied item, the
function randomly picks one from those with the proportions most
distant from desirable.
\item \code{MMM}: based on the desired proportions of content, the algorithm
builds a sum-one cumulative distribution. Then, a random number with
uniform distribution between zero and one is drawn. This number
corresponds to an area in the cumulative distribution. It is from
the content located in this area that the content will be selected.
}}
}
\value{
A numeric vector with the items that will be excluded for
selection. That is, it returns the unavailable items. If all items
are available, it returns \code{NULL}.
}
\description{
Constricts the selection with content balancing (CCAT or MCCAT)
}
\author{
Alexandre Jaloto
}
