% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_series.R
\name{sig_get_correlation}
\alias{sig_get_correlation}
\title{Get correlation matrix between signature activities}
\usage{
sig_get_correlation(cn_activity = NULL, snv_activity = NULL,
  type = c("absolute", "relative"), ...)
}
\arguments{
\item{cn_activity}{activity of copy number signature, a \code{list}, obtain it from
\link{sig_get_activity} function.}

\item{snv_activity}{activity of mutational signature, a \code{list}, obtain it from
\link{sig_get_activity} function.}

\item{type}{one of 'absolute' and 'relative'.}

\item{...}{other arguments pass to \code{\link[corrplot:cor.mtest]{corrplot::cor.mtest()}}.}
}
\value{
a \code{list}.
}
\description{
Compute correlation matrix and corresponding statistical test values between signature activies.
}
\examples{
# Load copy number signature
load(system.file("extdata", "toy_copynumber_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Get activity of signatures
sig_activity <- sig_get_activity(res$nmfObj)
# Get correlation matrix between signature activities
sig_cor <- sig_get_correlation(sig_activity)
}
\seealso{
Other signature analysis series function: \code{\link{sig_assign_samples}},
  \code{\link{sig_estimate}}, \code{\link{sig_extract}},
  \code{\link{sig_get_activity}},
  \code{\link{sig_get_similarity}},
  \code{\link{sig_prepare}},
  \code{\link{sig_summarize_subtypes}}
}
\author{
Shixiang Wang
}
\concept{signature analysis series function}
