% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_series.R
\name{draw_cn_distribution}
\alias{draw_cn_distribution}
\title{Plot copy number distribution either by length or chromosome}
\usage{
draw_cn_distribution(data, rm_normal = TRUE, mode = c("ld", "cd"),
  fill = FALSE, scale_chr = TRUE, genome_build = c("hg19", "hg38"))
}
\arguments{
\item{data}{result from \link{get_LengthFraction} function result or a \link{CopyNumber} object.}

\item{rm_normal}{logical. Whether remove normal copy (i.e. "segVal" equals 2), default is \code{TRUE}.}

\item{mode}{either "ld" for distribution by CN length or "cd" for distribution by chromosome.}

\item{fill}{when \code{mode} is "cd" and \code{fill} is \code{TRUE}, plot percentage instead of count.}

\item{scale_chr}{logical. If \code{TRUE}, normalize count to per Megabase unit.}

\item{genome_build}{genome build version, should be 'hg19' or 'hg38'.}
}
\value{
a ggplot object
}
\description{
Visually summarize copy number distribution either by copy number segment length
or chromosome. When input is a \link{CopyNumber} object, \code{genome_build} option will
read from \code{genome_build} slot of object instead of using argument set in function.
}
\examples{
# Load copy number object
load(system.file("extdata", "toy_copynumber.RData",
  package = "sigminer", mustWork = TRUE
))
# Plot distribution
draw_cn_distribution(cn)
draw_cn_distribution(cn, mode = "cd")
draw_cn_distribution(cn, mode = "cd", fill = TRUE)
}
\seealso{
Other copy number plot: \code{\link{draw_cn_components}},
  \code{\link{draw_cn_features}}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
\concept{copy number plot}
