% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_paginate_query.R
\name{auto_paginate_query}
\alias{auto_paginate_query}
\title{Auto Paginate Queries}
\usage{
auto_paginate_query(query, api_key, maxrows = 1e+06)
}
\arguments{
\item{query}{The SQL query to pass to ShroomDK}

\item{api_key}{ShroomDK API key.}

\item{maxrows}{Max rows allowed in ShroomDK, 1M at time of writing.}
}
\value{
data frame of up to 1M rows, see ?clean_query for more details on column classes.
}
\description{
Grabs up to maxrows in a query by going through each page 100k rows at a time.
}
\examples{
\dontrun{
pull_data <- auto_paginate_query("
SELECT * FROM ETHEREUM.CORE.FACT_TRANSACTIONS LIMIT 10000",
api_key = readLines("api_key.txt"))
}
}
