% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-tether.R
\name{model_tether}
\alias{model_tether}
\title{Model Using Instantaneous Tether device}
\usage{
model_tether(
  distance,
  velocity,
  weights = 1,
  CV = NULL,
  use_observed_MSS = FALSE,
  control = minpack.lm::nls.lm.control(maxiter = 1000),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{distance}{Numeric vector}

\item{velocity}{Numeric vector}

\item{weights}{Numeric vector. Default is 1}

\item{CV}{Should cross-validation be used to estimate model fit? Default is \code{NULL}. Otherwise use integer
indicating number of folds. See Example for more information}

\item{use_observed_MSS}{Should \code{MSS} be estimated from the observed \code{velocity}? Default is \code{FALSE}}

\item{control}{Control object forwarded to \code{\link[minpack.lm]{nlsLM}}. Default is \code{minpack.lm::nls.lm.control(maxiter = 1000)}}

\item{na.rm}{Logical. Default is FALSE}

\item{...}{Forwarded to \code{\link[minpack.lm]{nlsLM}} function}
}
\value{
List object with the following elements:
    \describe{
        \item{parameters}{List with the following estimated parameters:
            \code{MSS}, \code{TAU}, \code{MAC}, and \code{PMAX}}
        \item{model_fit}{List with the following components:
            \code{RSE}, \code{R_squared}, \code{minErr}, \code{maxErr}, and \code{RMSE}}
        \item{model}{Model returned by the \code{\link[minpack.lm]{nlsLM}} function}
        \item{data}{Data frame used to estimate the sprint parameters, consisting of \code{distance},
           \code{velocity}, \code{weights}, and \code{pred_velocity} columns}
        }
}
\description{
This function models the sprint instantaneous velocity using mono-exponential equation that estimates
    maximum sprinting speed (\code{MSS}) and relative acceleration (\code{TAU}). \code{velocity} is used as target or outcome
    variable, and \code{distance} as predictor.
}
\examples{
distance <- c(5, 10, 20, 30, 40)

velocity <- predict_velocity_at_distance(distance, MSS = 10, MAC = 8)

m1 <- model_tether(distance = distance, velocity = velocity)

m1

plot(m1)
}
