% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking.R
\name{use_tracking}
\alias{use_tracking}
\title{Insert dependencies to track usage of a Shiny app}
\usage{
use_tracking(
  on_unload = FALSE,
  exclude_input_regex = NULL,
  exclude_input_id = NULL
)
}
\arguments{
\item{on_unload}{Logical, save log when user close the browser window or tab,
if \code{TRUE} it prevent to create \code{shinylogs}
input during normal use of the application, there will
be created only on close, downside is that a popup will appear asking to close the page.}

\item{exclude_input_regex}{Regular expression to exclude inputs from tracking.}

\item{exclude_input_id}{Vector of \code{inputId} to exclude from tracking.}
}
\description{
If used in UI of an application,
this will create new \code{input}s available in the server.
Set \code{dependencies = FALSE} in \code{\link[=track_usage]{track_usage()}}
server-side to load dependencies only once.
}
\note{
The following \code{input}s will be accessible in the server:
\itemize{
\item \strong{.shinylogs_lastInput} : last \code{input} used by the user
\item \strong{.shinylogs_input} : all \code{input}s send from the browser to the server
\item \strong{.shinylogs_error} : all errors generated by \code{output}s elements
\item \strong{.shinylogs_output} : all \code{output}s generated from the server
\item \strong{.shinylogs_browserData} : information about the browser where application is displayed.
}
}
\examples{
if (interactive()) {

  library(shiny)
  library(shinylogs)

  ui <- fluidPage(

    # Load tracking dependencies
    use_tracking(),

    splitLayout(
      cellArgs = list(style = "height: 250px"),
      radioButtons("radio", "Radio:", names(iris)),
      checkboxGroupInput("checkbox", "Checkbox:", names(iris)),
      selectInput("select", "Select:", names(iris))
    ),

    tags$p("Last input used, the 'name' slot correspond to inputId:"),
    verbatimTextOutput("last")
  )

  server <- function(input, output, session) {

    output$last <- renderPrint({
      input$.shinylogs_lastInput
    })

  }

  shinyApp(ui, server)

}
}
