% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadablePlotly.R
\name{downloadablePlotlyUI}
\alias{downloadablePlotlyUI}
\title{UI for plotly with download data button in modebar}
\usage{
downloadablePlotlyUI(id, width = "100\%", height = "auto", inline = FALSE)
}
\arguments{
\item{id}{id string that gets namespaced by \code{shiny::NS}.}

\item{width}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended. Note that, for height, using "auto"
or "100\%" generally will not work as expected, because of how
height is computed with HTML/CSS.}

\item{height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended. Note that, for height, using "auto"
or "100\%" generally will not work as expected, because of how
height is computed with HTML/CSS.}

\item{inline}{use an inline (\code{span()}) or block container
(\code{div()}) for the output}
}
\value{
an HTML tag object corresponding to the UI for \code{downloadablePlotly}.
}
\description{
UI for plotly with download data button in modebar
}
\examples{
library(shiny)
library(shinyjs)
library(shinydlplot)
library(plotly)
ui <- fluidPage(
  useShinyjs(),
  downloadablePlotlyUI(id = 'iris')
)
server <- function(input, output, session) {

  plot <- plot_ly(data = iris, x = ~Sepal.Length, y = ~Petal.Length)

  callModule(downloadablePlotly,
             id = 'iris',
             plot = plot,
             filename = 'iris.csv',
             content = function(file) {write.csv(iris, file)})
}

\dontrun{shinyApp(ui, server)}

}
\seealso{
\code{\link[shiny]{NS}}, \code{\link{downloadablePlotly}}
}
