% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{useSweetAlert}
\alias{useSweetAlert}
\title{Load Sweet Alert dependencies}
\usage{
useSweetAlert(
  theme = c("sweetalert2", "minimal", "dark", "bootstrap-4", "material-ui", "bulma",
    "borderless"),
  ie = FALSE
)
}
\arguments{
\item{theme}{Theme to modify alerts appearance.}

\item{ie}{Add a polyfill to work in Internet Explorer.}
}
\description{
This function isn't necessary for \code{sendSweetAlert}, \code{confirmSweetAlert},
\code{inputSweetAlert} (except if you want to use a theme other than the default one),
but is still needed for \code{progressSweetAlert}.
}
\examples{
if (interactive()) {

  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(

    useSweetAlert("borderless", ie = TRUE),

    tags$h2("Sweet Alert examples (with custom theme)"),
    actionButton(
      inputId = "success",
      label = "Launch a success sweet alert",
      icon = icon("check")
    ),
    actionButton(
      inputId = "error",
      label = "Launch an error sweet alert",
      icon = icon("remove")
    ),
    actionButton(
      inputId = "sw_html",
      label = "Sweet alert with HTML",
      icon = icon("thumbs-up")
    )
  )

  server <- function(input, output, session) {

    observeEvent(input$success, {
      show_alert(
        title = "Success !!",
        text = "All in order",
        type = "success"
      )
    })

    observeEvent(input$error, {
      show_alert(
        title = "Error !!",
        text = "It's broken...",
        type = "error"
      )
    })

    observeEvent(input$sw_html, {
      show_alert(
        title = NULL,
        text = tags$span(
          tags$h3("With HTML tags",
                  style = "color: steelblue;"),
          "In", tags$b("bold"), "and", tags$em("italic"),
          tags$br(),
          "and",
          tags$br(),
          "line",
          tags$br(),
          "breaks",
          tags$br(),
          "and an icon", icon("thumbs-up")
        ),
        html = TRUE
      )
    })

  }

  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=sendSweetAlert]{sendSweetAlert()}}, \code{\link[=confirmSweetAlert]{confirmSweetAlert()}},
\code{\link[=inputSweetAlert]{inputSweetAlert()}}, \code{\link[=closeSweetAlert]{closeSweetAlert()}}.
}
