% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setSliderColor.R
\name{setSliderColor}
\alias{setSliderColor}
\title{Color editor for sliderInput}
\usage{
setSliderColor(color, sliderId)
}
\arguments{
\item{color}{The \code{color} to apply. This can also be a vector of colors if you want to customize more than 1 slider. Either
pass the name of the color such as 'Chartreuse ' and 'Chocolate 'or the HEX notation such as \code{'#7FFF00'} and \code{'#D2691E'}.}

\item{sliderId}{The \code{id} of the customized slider(s). This can be a vector like \code{c(1, 2)}, if you want to modify the 2 first sliders.
However, if you only want to modify the second slider, just use the value 2.}
}
\description{
Edit the color of the original shiny's sliderInputs
}
\note{
See also \url{https://www.w3schools.com/colors/colors_names.asp} to have an overview of all colors.
}
\examples{
\dontrun{

if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(

  # only customize the 2 first sliders and the last one
  # the color of the third one is empty
  setSliderColor(c("DeepPink ", "#FF4500", "", "Teal"), c(1, 2, 4)),
  sliderInput("obs", "My pink slider:",
              min = 0, max = 100, value = 50
  ),
  sliderInput("obs2", "My orange slider:",
              min = 0, max = 100, value = 50
  ),
  sliderInput("obs3", "My basic slider:",
              min = 0, max = 100, value = 50
  ),
  sliderInput("obs3", "My teal slider:",
              min = 0, max = 100, value = 50
  ),
  plotOutput("distPlot")
)

server <- function(input, output) {

  output$distPlot <- renderPlot({
    hist(rnorm(input$obs))
  })
}

shinyApp(ui, server)

}


}
}
\seealso{
See \code{\link{chooseSliderSkin}} to update the global skin of your sliders.
}
